/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client.clientcredentials;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.Internal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
class CacheableProcessor<T>
implements Processor<T, T> {
    @Nullable
    private T element;
    @Nullable
    private Throwable throwable;
    private boolean complete;
    @Nullable
    private Subscription subscription;
    @NonNull
    private List<ElementSubscription<T>> subscriptions = new ArrayList<ElementSubscription<T>>();
    @Nullable
    private final Function<T, T> transformer;

    CacheableProcessor() {
        this.transformer = null;
    }

    CacheableProcessor(@NonNull Function<T, T> transformer) {
        this.transformer = transformer;
    }

    public void clear() {
        this.complete = false;
        this.element = null;
        this.throwable = null;
        if (this.subscription != null) {
            this.subscription.cancel();
            this.subscription = null;
        }
        this.subscriptions = this.subscriptions.stream().filter(elementSubscription -> !elementSubscription.isCanceled() && !elementSubscription.isComplete()).collect(Collectors.toList());
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
    }

    public void onNext(T el) {
        this.element = this.transformer != null ? this.transformer.apply(el) : el;
        this.flowData();
    }

    public void onError(Throwable t) {
        this.throwable = t;
        this.flowData();
    }

    public void onComplete() {
        this.complete = true;
    }

    public void subscribe(Subscriber<? super T> s) {
        ElementSubscription<? super T> subscription = new ElementSubscription<T>(s, this);
        this.subscriptions.add(subscription);
        s.onSubscribe(subscription);
    }

    public void onElementsRequested() {
        if (this.element == null && this.subscription != null) {
            this.subscription.request(1L);
        } else {
            this.flowData();
        }
    }

    private void flowData() {
        for (ElementSubscription<T> s : this.subscriptions) {
            if (s.isCanceled() || s.isComplete()) continue;
            if (this.element != null) {
                if (!s.isElementsRequested()) continue;
                s.getSubscriber().onNext(this.element);
                s.setElementsRequested(false);
                if (!this.complete) continue;
                s.getSubscriber().onComplete();
                s.setComplete(true);
                continue;
            }
            if (this.throwable == null) continue;
            s.getSubscriber().onError(this.throwable);
        }
    }

    @Nullable
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Nullable
    public T getElement() {
        return this.element;
    }

    private static class ElementSubscription<T>
    implements Subscription {
        private final Subscriber<? super T> subscriber;
        private final CacheableProcessor<T> listener;
        private boolean canceled;
        private boolean elementsRequested;
        private boolean complete;

        public ElementSubscription(Subscriber<? super T> subscriber, CacheableProcessor<T> listener) {
            this.subscriber = subscriber;
            this.listener = listener;
        }

        public void setElementsRequested(boolean elementsRequested) {
            this.elementsRequested = elementsRequested;
        }

        public boolean isElementsRequested() {
            return this.elementsRequested;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public void setComplete(boolean complete) {
            this.complete = complete;
        }

        public Subscriber<? super T> getSubscriber() {
            return this.subscriber;
        }

        public void cancel() {
            this.canceled = true;
        }

        public void request(long n) {
            if (n > 0L) {
                this.elementsRequested = true;
                this.listener.onElementsRequested();
            }
        }
    }
}

