/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.SupplierUtil;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.security.oauth2.client.DefaultOpenIdClient;
import io.micronaut.security.oauth2.client.DefaultOpenIdProviderMetadata;
import io.micronaut.security.oauth2.client.condition.OpenIdClientCondition;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.EndSessionEndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.EndpointConfiguration;
import io.micronaut.security.oauth2.endpoint.authorization.request.AuthorizationRedirectHandler;
import io.micronaut.security.oauth2.endpoint.authorization.response.OpenIdAuthorizationResponseHandler;
import io.micronaut.security.oauth2.endpoint.endsession.request.EndSessionEndpoint;
import io.micronaut.security.oauth2.endpoint.endsession.request.EndSessionEndpointResolver;
import io.micronaut.security.oauth2.endpoint.endsession.response.EndSessionCallbackUrlBuilder;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdUserDetailsMapper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.function.Supplier;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
@Internal
@Requires(configuration="io.micronaut.security.token.jwt")
class OpenIdClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OpenIdClientFactory.class);
    private final BeanContext beanContext;

    OpenIdClientFactory(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @EachBean(value=OpenIdClientConfiguration.class)
    DefaultOpenIdProviderMetadata openIdConfiguration(@Parameter OauthClientConfiguration oauthClientConfiguration, @Parameter OpenIdClientConfiguration openIdClientConfiguration, @Client HttpClient issuerClient) {
        DefaultOpenIdProviderMetadata providerMetadata = openIdClientConfiguration.getIssuer().map(issuer -> {
            try {
                URL configurationUrl = new URL((URL)issuer, StringUtils.prependUri((String)issuer.getPath(), (String)openIdClientConfiguration.getConfigurationPath()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending request for OpenID configuration for provider [{}] to URL [{}]", (Object)openIdClientConfiguration.getName(), (Object)configurationUrl);
                }
                return (DefaultOpenIdProviderMetadata)issuerClient.toBlocking().retrieve(configurationUrl.toString(), DefaultOpenIdProviderMetadata.class);
            }
            catch (HttpClientResponseException e) {
                throw new BeanInstantiationException("Failed to retrieve OpenID configuration for " + openIdClientConfiguration.getName(), (Throwable)e);
            }
            catch (MalformedURLException e) {
                throw new BeanInstantiationException("Failure parsing issuer URL " + issuer.toString(), (Throwable)e);
            }
        }).orElse(new DefaultOpenIdProviderMetadata());
        this.overrideFromConfig(providerMetadata, openIdClientConfiguration, oauthClientConfiguration);
        return providerMetadata;
    }

    @EachBean(value=OpenIdClientConfiguration.class)
    @Requires(condition=OpenIdClientCondition.class)
    DefaultOpenIdClient openIdClient(@Parameter OpenIdClientConfiguration openIdClientConfiguration, @Parameter OauthClientConfiguration clientConfiguration, @Parameter Provider<DefaultOpenIdProviderMetadata> openIdProviderMetadata, @Parameter @Nullable OpenIdUserDetailsMapper userDetailsMapper, AuthorizationRedirectHandler redirectUrlBuilder, OpenIdAuthorizationResponseHandler authorizationResponseHandler, EndSessionEndpointResolver endSessionEndpointResolver, EndSessionCallbackUrlBuilder endSessionCallbackUrlBuilder) {
        Supplier metadataSupplier = SupplierUtil.memoized(() -> openIdProviderMetadata.get());
        EndSessionEndpoint endSessionEndpoint = null;
        if (openIdClientConfiguration.getEndSession().isEnabled()) {
            endSessionEndpoint = endSessionEndpointResolver.resolve(clientConfiguration, metadataSupplier, endSessionCallbackUrlBuilder).orElse(null);
        }
        return new DefaultOpenIdClient(clientConfiguration, metadataSupplier, userDetailsMapper, redirectUrlBuilder, authorizationResponseHandler, this.beanContext, endSessionEndpoint);
    }

    private void overrideFromConfig(DefaultOpenIdProviderMetadata configuration, OpenIdClientConfiguration openIdClientConfiguration, OauthClientConfiguration oauthClientConfiguration) {
        openIdClientConfiguration.getJwksUri().ifPresent(configuration::setJwksUri);
        oauthClientConfiguration.getIntrospection().ifPresent(introspection -> {
            introspection.getUrl().ifPresent(configuration::setIntrospectionEndpoint);
            introspection.getAuthMethod().ifPresent(authMethod -> configuration.setIntrospectionEndpointAuthMethodsSupported(Collections.singletonList(authMethod.toString())));
        });
        oauthClientConfiguration.getRevocation().ifPresent(revocation -> {
            revocation.getUrl().ifPresent(configuration::setRevocationEndpoint);
            revocation.getAuthMethod().ifPresent(authMethod -> configuration.setRevocationEndpointAuthMethodsSupported(Collections.singletonList(authMethod.toString())));
        });
        openIdClientConfiguration.getRegistration().flatMap(EndpointConfiguration::getUrl).ifPresent(configuration::setRegistrationEndpoint);
        openIdClientConfiguration.getUserInfo().flatMap(EndpointConfiguration::getUrl).ifPresent(configuration::setUserinfoEndpoint);
        openIdClientConfiguration.getAuthorization().flatMap(EndpointConfiguration::getUrl).ifPresent(configuration::setAuthorizationEndpoint);
        openIdClientConfiguration.getToken().ifPresent(token -> {
            token.getUrl().ifPresent(configuration::setTokenEndpoint);
            token.getAuthMethod().ifPresent(authMethod -> configuration.setTokenEndpointAuthMethodsSupported(Collections.singletonList(authMethod.toString())));
        });
        EndSessionEndpointConfiguration endSession = openIdClientConfiguration.getEndSession();
        if (endSession.isEnabled()) {
            endSession.getUrl().ifPresent(configuration::setEndSessionEndpoint);
        }
    }
}

