/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.ldap;

import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.AuthenticationException;
import io.micronaut.security.authentication.AuthenticationFailureReason;
import io.micronaut.security.authentication.AuthenticationProvider;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.ldap.ContextAuthenticationMapper;
import io.micronaut.security.ldap.configuration.LdapConfiguration;
import io.micronaut.security.ldap.context.ContextBuilder;
import io.micronaut.security.ldap.context.LdapSearchResult;
import io.micronaut.security.ldap.context.LdapSearchService;
import io.micronaut.security.ldap.group.LdapGroupProcessor;
import io.micronaut.security.utils.LoggingUtils;
import jakarta.inject.Named;
import java.io.Closeable;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class LdapAuthenticationProvider
implements AuthenticationProvider,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LdapAuthenticationProvider.class);
    private final LdapConfiguration configuration;
    private final LdapSearchService ldapSearchService;
    private final ContextBuilder contextBuilder;
    private final ContextAuthenticationMapper contextAuthenticationMapper;
    private final LdapGroupProcessor ldapGroupProcessor;
    private final Scheduler scheduler;

    public LdapAuthenticationProvider(LdapConfiguration configuration, LdapSearchService ldapSearchService, ContextBuilder contextBuilder, ContextAuthenticationMapper contextAuthenticationMapper, LdapGroupProcessor ldapGroupProcessor, @Named(value="io") ExecutorService executorService) {
        this.configuration = configuration;
        this.ldapSearchService = ldapSearchService;
        this.contextBuilder = contextBuilder;
        this.contextAuthenticationMapper = contextAuthenticationMapper;
        this.ldapGroupProcessor = ldapGroupProcessor;
        this.scheduler = Schedulers.fromExecutorService((ExecutorService)executorService);
    }

    public Publisher<AuthenticationResponse> authenticate(HttpRequest<?> httpRequest, AuthenticationRequest<?, ?> authenticationRequest) {
        Flux reactiveSequence = Flux.create(emitter -> {
            block19: {
                DirContext managerContext;
                String username = authenticationRequest.getIdentity().toString();
                String password = authenticationRequest.getSecret().toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Starting authentication with configuration [{}]", (Object)this.configuration.getName());
                    LOG.debug("Attempting to initialize manager context");
                }
                try {
                    managerContext = this.contextBuilder.build(this.configuration.getManagerSettings());
                    LoggingUtils.debug((Logger)LOG, (String)"Manager context initialized successfully", (Object[])new Object[0]);
                }
                catch (NamingException e) {
                    LoggingUtils.debug((Logger)LOG, (String)"Failed to create manager context. Returning unknown authentication failure. Encountered {}", (Object[])new Object[]{e.getMessage()});
                    emitter.error((Throwable)AuthenticationResponse.exception((AuthenticationFailureReason)AuthenticationFailureReason.UNKNOWN));
                    return;
                }
                LoggingUtils.debug((Logger)LOG, (String)"Attempting to authenticate with user [{}]", (Object[])new Object[]{username});
                try {
                    Optional<LdapSearchResult> optionalResult = this.ldapSearchService.searchFirst(managerContext, this.configuration.getSearch().getSettings(new Object[]{username}));
                    if (optionalResult.isPresent()) {
                        AuthenticationResponse response;
                        LdapSearchResult result = optionalResult.get();
                        LoggingUtils.debug((Logger)LOG, (String)"User found in context [{}]. Attempting to bind.", (Object[])new Object[]{result.getDn()});
                        DirContext userContext = null;
                        try {
                            String dn = result.getDn();
                            userContext = this.contextBuilder.build(this.configuration.getSettings(result.getDn(), password));
                            if (result.getAttributes() == null) {
                                result.setAttributes(userContext.getAttributes(dn));
                            }
                            this.contextBuilder.close(userContext);
                        }
                        catch (Throwable throwable) {
                            this.contextBuilder.close(userContext);
                            throw throwable;
                        }
                        LoggingUtils.debug((Logger)LOG, (String)"Successfully bound user [{}]. Attempting to retrieving groups.", (Object[])new Object[]{result.getDn()});
                        Set<String> groups = Collections.emptySet();
                        LdapConfiguration.GroupConfiguration groupSettings = this.configuration.getGroups();
                        if (groupSettings.isEnabled()) {
                            groups = this.ldapGroupProcessor.process(groupSettings.getAttribute(), result, () -> {
                                Object[] params = new Object[]{groupSettings.getFilterAttribute().map(attr -> result.getAttributes().getValue((CharSequence)attr)).orElse(result.getDn())};
                                return this.ldapSearchService.search(managerContext, groupSettings.getSearchSettings(params));
                            });
                            LoggingUtils.debug((Logger)LOG, (String)"Group search returned [{}] for user [{}]", (Object[])new Object[]{groups, username});
                        } else {
                            LoggingUtils.debug((Logger)LOG, (String)"Group search is disabled for configuration [{}]", (Object[])new Object[]{this.configuration.getName()});
                        }
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Attempting to map [{}] with groups [{}] to an authentication response.", (Object)username, groups);
                        }
                        if ((response = this.contextAuthenticationMapper.map(result.getAttributes(), username, groups)).isAuthenticated()) {
                            emitter.next((Object)response);
                            emitter.complete();
                        } else {
                            emitter.error((Throwable)new AuthenticationException(response));
                        }
                        LoggingUtils.debug((Logger)LOG, (String)"Response successfully created for [{}]. Response is authenticated: [{}]", (Object[])new Object[]{username, response.isAuthenticated()});
                        break block19;
                    }
                    LoggingUtils.debug((Logger)LOG, (String)"User not found [{}]", (Object[])new Object[]{username});
                    emitter.error((Throwable)AuthenticationResponse.exception((AuthenticationFailureReason)AuthenticationFailureReason.USER_NOT_FOUND));
                }
                catch (NamingException e) {
                    LoggingUtils.debug((Logger)LOG, (String)"Failed to authenticate with user [{}].  {}", (Object[])new Object[]{username, e});
                    if (e instanceof javax.naming.AuthenticationException) {
                        emitter.error((Throwable)AuthenticationResponse.exception((AuthenticationFailureReason)AuthenticationFailureReason.CREDENTIALS_DO_NOT_MATCH));
                    } else {
                        emitter.error((Throwable)e);
                    }
                }
                finally {
                    this.contextBuilder.close(managerContext);
                }
            }
        }, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.ERROR);
        reactiveSequence = reactiveSequence.subscribeOn(this.scheduler);
        return reactiveSequence;
    }

    @Override
    public void close() {
    }
}

