/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.ldap.context;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class AttributesConvertibleValues
implements ConvertibleValues<Object> {
    private final Attributes attributes;
    private final ConversionService conversionService = ConversionService.SHARED;

    public AttributesConvertibleValues(Attributes attributes) {
        this.attributes = attributes;
    }

    public Set<String> names() {
        HashSet<String> names = new HashSet<String>();
        NamingEnumeration<String> ids = this.attributes.getIDs();
        try {
            while (ids.hasMore()) {
                names.add(ids.next());
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return names;
    }

    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>(this.attributes.size());
        NamingEnumeration<? extends Attribute> all = this.attributes.getAll();
        try {
            while (all.hasMore()) {
                values.add(all.next().get());
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return values;
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        try {
            Attribute attr = this.attributes.get(name.toString());
            if (attr == null) {
                return Optional.empty();
            }
            NamingEnumeration<?> enumeration = attr.getAll();
            ArrayList results = new ArrayList();
            while (enumeration.hasMore()) {
                results.add(enumeration.next());
            }
            if (!results.isEmpty()) {
                ArrayList<Object> value = results.size() > 1 ? results : results.get(0);
                return this.conversionService.convert(value, conversionContext);
            }
            return Optional.empty();
        }
        catch (NamingException e) {
            return Optional.empty();
        }
    }
}

