/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.security.ldap.configuration;

import io.micronaut.configuration.security.ldap.configuration.GroupPropertiesSearchSettings;
import io.micronaut.configuration.security.ldap.configuration.SearchPropertiesSearchSettings;
import io.micronaut.configuration.security.ldap.context.ContextConfigurationContextSettings;
import io.micronaut.configuration.security.ldap.context.ContextSettings;
import io.micronaut.configuration.security.ldap.context.SearchSettings;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.util.Toggleable;
import java.util.Collections;
import java.util.Map;

@EachProperty(value="micronaut.security.ldap", primary="default")
public class LdapConfiguration
implements Toggleable {
    public static final String PREFIX = "micronaut.security.ldap";
    public static final boolean DEFAULT_ENABLED = true;
    private boolean enabled = true;
    private ContextConfiguration context = new ContextConfiguration();
    private SearchConfiguration search = new SearchConfiguration();
    private GroupConfiguration group = new GroupConfiguration();
    private final String name;

    LdapConfiguration(@Parameter String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ContextConfiguration getContext() {
        return this.context;
    }

    public void setContext(ContextConfiguration contextConfiguration) {
        this.context = contextConfiguration;
    }

    public SearchConfiguration getSearch() {
        return this.search;
    }

    public void setSearch(SearchConfiguration searchConfiguration) {
        this.search = searchConfiguration;
    }

    public GroupConfiguration getGroups() {
        return this.group;
    }

    public void setGroups(GroupConfiguration groupConfiguration) {
        this.group = groupConfiguration;
    }

    public ContextSettings getSettings(String dn, String password) {
        return new ContextConfigurationContextSettings(this, dn, password);
    }

    public ContextSettings getManagerSettings() {
        return new ContextConfigurationContextSettings(this);
    }

    @ConfigurationProperties(value="groups")
    public static class GroupConfiguration
    implements Toggleable {
        public static final String PREFIX = "micronaut.security.ldap.groups";
        public static final boolean DEFAULT_ENABLED = false;
        private static final boolean DEFAULT_SUBTREE = true;
        private static final String DEFAULT_FILTER = "uniquemember={0}";
        private static final String DEFAULT_ATTR = "cn";
        private boolean enabled = false;
        private boolean subtree = true;
        private String base = "";
        private String filter = "uniquemember={0}";
        private String attribute = "cn";

        public boolean isSubtree() {
            return this.subtree;
        }

        public void setSubtree(boolean subtree) {
            this.subtree = subtree;
        }

        public String getBase() {
            return this.base;
        }

        public void setBase(String base) {
            this.base = base;
        }

        public String getFilter() {
            return this.filter;
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public SearchSettings getSearchSettings(Object[] arguments) {
            return new GroupPropertiesSearchSettings(this, arguments);
        }
    }

    @ConfigurationProperties(value="search")
    public static class SearchConfiguration {
        public static final String PREFIX = "micronaut.security.ldap.search";
        private static final boolean DEFAULT_SUBTREE = true;
        private static final String DEFAULT_FILTER = "(uid={0})";
        private boolean subtree = true;
        private String base = "";
        private String filter = "(uid={0})";
        private String[] attributes = null;

        public boolean isSubtree() {
            return this.subtree;
        }

        public void setSubtree(boolean subtree) {
            this.subtree = subtree;
        }

        public String getBase() {
            return this.base;
        }

        public void setBase(String base) {
            this.base = base;
        }

        public String getFilter() {
            return this.filter;
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public String[] getAttributes() {
            return this.attributes;
        }

        public void setAttributes(String[] attributes) {
            this.attributes = attributes;
        }

        public SearchSettings getSettings(Object[] arguments) {
            return new SearchPropertiesSearchSettings(this, arguments);
        }
    }

    @ConfigurationProperties(value="context")
    public static class ContextConfiguration {
        public static final String PREFIX = "micronaut.security.ldap.context";
        private static final String DEFAULT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
        private String server;
        private String managerDn;
        private String managerPassword;
        private String factory = "com.sun.jndi.ldap.LdapCtxFactory";
        private Map<String, Object> properties = Collections.emptyMap();

        public String getServer() {
            return this.server;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public String getManagerDn() {
            return this.managerDn;
        }

        public void setManagerDn(String managerDn) {
            this.managerDn = managerDn;
        }

        public String getManagerPassword() {
            return this.managerPassword;
        }

        public void setManagerPassword(String managerPassword) {
            this.managerPassword = managerPassword;
        }

        public String getFactory() {
            return this.factory;
        }

        public void setFactory(String factory) {
            this.factory = factory;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }
    }
}

