/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.security.ldap.context;

import io.micronaut.configuration.security.ldap.context.LdapSearchResult;
import io.micronaut.configuration.security.ldap.context.LdapSearchService;
import io.micronaut.configuration.security.ldap.context.SearchSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Singleton;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

@Singleton
public class DefaultLdapSearchService
implements LdapSearchService {
    @Override
    public Optional<LdapSearchResult> searchFirst(DirContext managerContext, SearchSettings settings) throws NamingException {
        List<LdapSearchResult> results = this.search(managerContext, settings);
        if (results.size() > 0) {
            LdapSearchResult result = results.get(0);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    @Override
    public List<LdapSearchResult> search(DirContext managerContext, SearchSettings settings) throws NamingException {
        SearchControls ctrls = new SearchControls();
        ctrls.setReturningAttributes(settings.getAttributes());
        if (settings.isSubtree()) {
            ctrls.setSearchScope(2);
        }
        NamingEnumeration<SearchResult> results = managerContext.search(settings.getBase(), settings.getFilter(), settings.getArguments(), ctrls);
        return this.createResults(results);
    }

    protected List<LdapSearchResult> createResults(NamingEnumeration<SearchResult> results) throws NamingException {
        ArrayList<LdapSearchResult> searchResults = new ArrayList<LdapSearchResult>();
        while (results.hasMore()) {
            SearchResult result = results.next();
            Attributes attributes = result.getAttributes();
            String dn = result.getNameInNamespace();
            searchResults.add(new LdapSearchResult(attributes, dn));
        }
        return searchResults;
    }
}

