/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.nimbus;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.token.jwt.nimbus.AbstractJsonWebTokenValidator;
import io.micronaut.security.token.jwt.signature.ReactiveSignatureConfiguration;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.JsonWebTokenParser;
import io.micronaut.security.token.jwt.validator.JsonWebTokenSignatureValidator;
import io.micronaut.security.token.jwt.validator.JsonWebTokenValidator;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;

@Singleton
class NimbusJsonWebTokenValidator<R>
extends AbstractJsonWebTokenValidator<R>
implements JsonWebTokenValidator<JWT, R> {
    private final JsonWebTokenParser<JWT> jsonWebTokenParser;
    private final JsonWebTokenSignatureValidator<SignedJWT> signatureValidator;

    NimbusJsonWebTokenValidator(List<GenericJwtClaimsValidator<R>> claimsValidators, List<SignatureConfiguration> imperativeSignatureConfigurations, List<ReactiveSignatureConfiguration<SignedJWT>> reactiveSignatureConfigurations, JsonWebTokenParser<JWT> jsonWebTokenParser, JsonWebTokenSignatureValidator<SignedJWT> signatureValidator) {
        super(claimsValidators, imperativeSignatureConfigurations, reactiveSignatureConfigurations);
        this.jsonWebTokenParser = jsonWebTokenParser;
        this.signatureValidator = signatureValidator;
    }

    @Override
    @NonNull
    public Optional<JWT> validate(@NonNull String token, @Nullable R request) {
        Optional<JWT> jwtOptional = this.jsonWebTokenParser.parse(token);
        if (jwtOptional.isEmpty()) {
            return Optional.empty();
        }
        JWT jwt = jwtOptional.get();
        if (!this.validateSignature(jwt)) {
            return Optional.empty();
        }
        if (!this.validateClaims(jwt, request)) {
            return Optional.empty();
        }
        return Optional.of(jwt);
    }

    private boolean validateSignature(JWT jwt) {
        if (jwt instanceof PlainJWT) {
            PlainJWT plainJWT = (PlainJWT)jwt;
            return this.validateSignature(plainJWT);
        }
        if (jwt instanceof SignedJWT) {
            SignedJWT signedJWT = (SignedJWT)jwt;
            return this.signatureValidator.validateSignature(signedJWT);
        }
        return false;
    }
}

