/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.jwks;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.core.annotation.Blocking;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.signature.jwks.JwkSetFetcher;
import io.micronaut.security.token.jwt.signature.jwks.JwkValidator;
import io.micronaut.security.token.jwt.signature.jwks.JwksCache;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignatureConfiguration;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignatureUtils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@EachBean(value=JwksSignatureConfiguration.class)
public class JwksSignature
implements JwksCache,
SignatureConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(JwksSignature.class);
    private final JwkValidator jwkValidator;
    private final JwksSignatureConfiguration jwksSignatureConfiguration;
    private volatile Instant jwkSetCachedAt;
    private volatile JWKSet jwkSet;
    private final JwkSetFetcher<JWKSet> jwkSetFetcher;

    public JwksSignature(JwksSignatureConfiguration jwksSignatureConfiguration, JwkValidator jwkValidator, JwkSetFetcher<JWKSet> jwkSetFetcher) {
        this.jwksSignatureConfiguration = jwksSignatureConfiguration;
        this.jwkValidator = jwkValidator;
        this.jwkSetFetcher = jwkSetFetcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<JWKSet> computeJWKSet() {
        JWKSet jwkSetVariable = this.jwkSet;
        if (jwkSetVariable == null) {
            JwksSignature jwksSignature = this;
            synchronized (jwksSignature) {
                jwkSetVariable = this.jwkSet;
                if (jwkSetVariable == null) {
                    this.jwkSet = jwkSetVariable = this.loadJwkSet(this.jwksSignatureConfiguration.getName(), this.jwksSignatureConfiguration.getUrl());
                    this.jwkSetCachedAt = Instant.now().plus((long)this.jwksSignatureConfiguration.getCacheExpiration().intValue(), ChronoUnit.SECONDS);
                }
            }
        }
        return Optional.ofNullable(jwkSetVariable);
    }

    private List<JWK> getJsonWebKeys() {
        return this.computeJWKSet().map(JWKSet::getKeys).orElse(Collections.emptyList());
    }

    @Override
    public boolean isExpired() {
        Instant cachedAt = this.jwkSetCachedAt;
        return cachedAt != null && Instant.now().isAfter(cachedAt);
    }

    @Override
    public void clear() {
        this.jwkSetFetcher.clearCache(this.jwksSignatureConfiguration.getUrl());
        this.jwkSet = null;
        this.jwkSetCachedAt = null;
    }

    @Override
    public boolean isPresent() {
        return this.jwkSet != null;
    }

    @Override
    @NonNull
    public Optional<List<String>> getKeyIds() {
        return this.computeJWKSet().map(JWKSet::getKeys).map(jwkList -> jwkList.stream().map(JWK::getKeyID).collect(Collectors.toList()));
    }

    @Override
    public String supportedAlgorithmsMessage() {
        return JwksSignatureUtils.supportedAlgorithmsMessage(this.getJsonWebKeys());
    }

    @Override
    public boolean supports(JWSAlgorithm algorithm) {
        return JwksSignatureUtils.supports(algorithm, this.getJsonWebKeys());
    }

    @Override
    public boolean verify(SignedJWT jwt) throws JOSEException {
        return JwksSignatureUtils.verify(jwt, this.computeJWKSet().orElse(null), this.jwkValidator);
    }

    @Nullable
    @Blocking
    @Deprecated(forRemoval=true, since="4.5.0")
    protected JWKSet loadJwkSet(String url) {
        LOG.debug("Fetching JWK Set from {}", (Object)url);
        return Mono.from(this.jwkSetFetcher.fetch(null, url)).blockOptional().orElse(null);
    }

    @Nullable
    @Blocking
    protected JWKSet loadJwkSet(@Nullable String providerName, String url) {
        LOG.debug("Fetching JWK Set from {}", (Object)url);
        return Mono.from(this.jwkSetFetcher.fetch(providerName, url)).blockOptional().orElse(null);
    }

    @Deprecated
    protected List<JWK> matches(SignedJWT jwt, @Nullable JWKSet jwkSet) {
        return JwksSignatureUtils.matches(jwt, jwkSet, this.jwksSignatureConfiguration.getKeyType());
    }

    protected boolean verify(List<JWK> matches, SignedJWT jwt) {
        return matches.stream().anyMatch(jwk -> this.jwkValidator.validate(jwt, (JWK)jwk));
    }
}

