/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.jwks;

import com.nimbusds.jose.jwk.JWKSet;
import io.micronaut.core.annotation.Blocking;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.optim.StaticOptimizations;
import io.micronaut.security.token.jwt.signature.jwks.JwkSetFetcher;
import io.micronaut.security.token.jwt.signature.jwks.JwksClient;
import io.micronaut.security.token.jwt.signature.jwks.ResourceRetrieverJwksClient;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Singleton
public class DefaultJwkSetFetcher
implements JwkSetFetcher<JWKSet> {
    public static final Optimizations OPTIMIZATIONS = StaticOptimizations.get(Optimizations.class).orElse(new Optimizations(Collections.emptyMap()));
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJwkSetFetcher.class);
    private final JwksClient jwksClient;

    @Deprecated(forRemoval=true, since="4.5.0")
    public DefaultJwkSetFetcher() {
        this(new ResourceRetrieverJwksClient(Schedulers.boundedElastic()));
    }

    @Inject
    public DefaultJwkSetFetcher(JwksClient jwksClient) {
        this.jwksClient = jwksClient;
    }

    @Override
    @NonNull
    @Blocking
    @Deprecated(forRemoval=true, since="4.5.0")
    public Optional<JWKSet> fetch(String url) {
        return Mono.from(this.fetch(null, url)).blockOptional();
    }

    @Override
    @NonNull
    @SingleResult
    public Publisher<JWKSet> fetch(@Nullable String providerName, @Nullable String url) {
        if (url == null) {
            return Mono.empty();
        }
        Optional<Publisher> optionalJWKSetPublisher = OPTIMIZATIONS.findJwkSet(url).map(Supplier::get).map(Mono::just);
        return optionalJWKSetPublisher.orElseGet(() -> this.load(providerName, url));
    }

    @Override
    public void clearCache(@NonNull String url) {
        OPTIMIZATIONS.clear(url);
    }

    @Nullable
    @SingleResult
    private Publisher<JWKSet> load(@Nullable String providerName, @NonNull String url) {
        return Mono.from(this.jwksClient.load(providerName, url)).mapNotNull(jwkSetContent -> {
            try {
                return JWKSet.parse((String)jwkSetContent);
            }
            catch (ParseException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Exception parsing JWK Set response from " + url, (Throwable)e);
                }
                return null;
            }
        });
    }

    public static class Optimizations {
        private final Map<String, Supplier<JWKSet>> suppliers;

        public Optimizations(@NonNull Map<String, Supplier<JWKSet>> suppliers) {
            this.suppliers = suppliers;
        }

        public Optional<Supplier<JWKSet>> findJwkSet(@NonNull String url) {
            return Optional.ofNullable(this.suppliers.get(url));
        }

        public void clear(@NonNull String url) {
            this.suppliers.remove(url);
        }
    }
}

