/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.jwks;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.core.annotation.Internal;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.signature.jwks.JwkValidator;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignatureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class JWKSetJwksSignature
implements SignatureConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(JWKSetJwksSignature.class);
    private final JWKSet jwkSet;
    private final JwkValidator jwkValidator;

    public JWKSetJwksSignature(JwkValidator jwkValidator, JWKSet jwkSet) {
        this.jwkValidator = jwkValidator;
        this.jwkSet = jwkSet;
    }

    @Override
    public String supportedAlgorithmsMessage() {
        return JwksSignatureUtils.supportedAlgorithmsMessage(this.jwkSet);
    }

    @Override
    public boolean supports(JWSAlgorithm algorithm) {
        return JwksSignatureUtils.supports(algorithm, this.jwkSet);
    }

    @Override
    public boolean verify(SignedJWT jwt) throws JOSEException {
        return JwksSignatureUtils.verify(jwt, this.jwkSet, this.jwkValidator);
    }
}

