/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.jwks;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpClientRegistry;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.ServiceHttpClientConfiguration;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.token.jwt.signature.jwks.JwksClient;
import jakarta.inject.Singleton;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Singleton
@Requirements(value={@Requires(classes={HttpClient.class}), @Requires(property="micronaut.security.token.jwt.signatures.jwks-client.http-client.enabled", value="true", defaultValue="true")})
public class HttpClientJwksClient
implements JwksClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientJwksClient.class);
    private final BeanContext beanContext;
    private final HttpClientRegistry<HttpClient> clientRegistry;
    private final Supplier<HttpClient> defaultJwkSetClient;
    private final ConcurrentHashMap<String, HttpClient> jwkSetClients = new ConcurrentHashMap();

    public HttpClientJwksClient(BeanContext beanContext, HttpClientRegistry<HttpClient> clientRegistry, HttpClientConfiguration defaultClientConfiguration) {
        this.beanContext = beanContext;
        this.clientRegistry = clientRegistry;
        this.defaultJwkSetClient = SupplierUtil.memoized(() -> (HttpClient)beanContext.createBean(HttpClient.class, new Object[]{LoadBalancer.empty(), defaultClientConfiguration}));
    }

    @Override
    @SingleResult
    public Publisher<String> load(@Nullable String providerName, @NonNull String url) throws HttpClientException {
        return Mono.from((Publisher)this.getClient(providerName).retrieve(url)).onErrorResume(HttpClientException.class, throwable -> {
            if (LOG.isErrorEnabled()) {
                LOG.error("Exception loading JWK from " + url, (Throwable)throwable);
            }
            return Mono.empty();
        });
    }

    protected HttpClient getClient(@Nullable String providerName) {
        if (providerName == null) {
            return this.defaultJwkSetClient.get();
        }
        return this.jwkSetClients.computeIfAbsent(providerName, provider -> this.beanContext.findBean(ServiceHttpClientConfiguration.class, Qualifiers.byName((String)provider)).map(serviceConfig -> this.clientRegistry.getClient(HttpVersionSelection.forClientConfiguration((HttpClientConfiguration)serviceConfig), provider, "/")).orElseGet(this.defaultJwkSetClient));
    }
}

