/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.jwks;

import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.Resource;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.security.token.jwt.signature.jwks.JwksClient;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Singleton
@Secondary
public class ResourceRetrieverJwksClient
implements JwksClient {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceRetrieverJwksClient.class);
    private final Scheduler scheduler;
    private final DefaultResourceRetriever resourceRetriever = new DefaultResourceRetriever(0, 0, 0);

    @Inject
    public ResourceRetrieverJwksClient(@Named(value="blocking") ExecutorService executorService) {
        this(Schedulers.fromExecutorService((ExecutorService)executorService));
    }

    public ResourceRetrieverJwksClient(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    @SingleResult
    public Publisher<String> load(String providerName, String url) {
        return Mono.fromCallable(() -> {
            try {
                return this.resourceRetriever.retrieveResource(new URL(url));
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Exception loading JWK from " + url, (Throwable)e);
                }
                return null;
            }
        }).map(Resource::getContent).subscribeOn(this.scheduler);
    }
}

