/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.nimbus;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.jwt.nimbus.AbstractJsonWebTokenValidator;
import io.micronaut.security.token.jwt.nimbus.NimbusJsonWebTokenValidatorConfiguration;
import io.micronaut.security.token.jwt.signature.ReactiveSignatureConfiguration;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.JsonWebTokenParser;
import io.micronaut.security.token.jwt.validator.JwtAuthenticationFactory;
import io.micronaut.security.token.jwt.validator.ReactiveJsonWebTokenSignatureValidator;
import io.micronaut.security.token.jwt.validator.ReactiveJsonWebTokenValidator;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Singleton
@Requires(property="micronaut.security.token.jwt.nimbus.reactive-validator", value="true", defaultValue="true")
class NimbusReactiveJsonWebTokenValidator<R>
extends AbstractJsonWebTokenValidator<R>
implements ReactiveJsonWebTokenValidator<JWT, R> {
    private final JwtAuthenticationFactory jwtAuthenticationFactory;
    private final JsonWebTokenParser<JWT> jsonWebTokenParser;
    @Nullable
    private final Scheduler scheduler;
    private final ReactiveJsonWebTokenSignatureValidator<SignedJWT> signatureValidator;

    NimbusReactiveJsonWebTokenValidator(List<GenericJwtClaimsValidator<R>> claimsValidators, List<SignatureConfiguration> imperativeSignatureConfigurations, List<ReactiveSignatureConfiguration<SignedJWT>> reactiveSignatureConfigurations, JsonWebTokenParser<JWT> jsonWebTokenParser, ReactiveJsonWebTokenSignatureValidator<SignedJWT> signatureValidator, JwtAuthenticationFactory jwtAuthenticationFactory, @Named(value="blocking") ExecutorService executorService, NimbusJsonWebTokenValidatorConfiguration nimbusJsonWebTokenValidatorConfiguration) {
        super(claimsValidators, imperativeSignatureConfigurations, reactiveSignatureConfigurations);
        this.jsonWebTokenParser = jsonWebTokenParser;
        this.signatureValidator = signatureValidator;
        this.jwtAuthenticationFactory = jwtAuthenticationFactory;
        this.scheduler = nimbusJsonWebTokenValidatorConfiguration.isReactiveValidatorExecuteOnBlocking() ? Schedulers.fromExecutorService((ExecutorService)executorService) : null;
    }

    @SingleResult
    public Publisher<Authentication> validateToken(String token, R request) {
        Mono authenticationMono = Mono.from(this.validate(token, request)).map(this.jwtAuthenticationFactory::createAuthentication).filter(Optional::isPresent).map(Optional::get);
        return this.scheduler != null ? authenticationMono.subscribeOn(this.scheduler) : authenticationMono;
    }

    @Override
    @NonNull
    public Publisher<JWT> validate(@NonNull String token, @Nullable R request) {
        Optional<JWT> jwtOptional = this.jsonWebTokenParser.parse(token);
        if (jwtOptional.isEmpty()) {
            return Mono.empty();
        }
        JWT jwt = jwtOptional.get();
        return this.validateSignature(jwt).filter(valid -> valid != false && this.validateClaims(jwt, request)).map(valid -> jwt);
    }

    private Mono<Boolean> validateSignature(JWT jwt) {
        if (jwt instanceof PlainJWT) {
            PlainJWT plainJWT = (PlainJWT)jwt;
            return Mono.just((Object)this.validateSignature(plainJWT));
        }
        if (jwt instanceof SignedJWT) {
            SignedJWT signedJWT = (SignedJWT)jwt;
            return Mono.from(this.signatureValidator.validateSignature(signedJWT));
        }
        return Mono.just((Object)false);
    }
}

