/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.nimbus;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.validator.JsonWebTokenSignatureValidator;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Singleton
class NimbusJsonWebTokenSignatureValidator
implements JsonWebTokenSignatureValidator<SignedJWT> {
    private static final Logger LOG = LoggerFactory.getLogger(NimbusJsonWebTokenSignatureValidator.class);
    private final List<SignatureConfiguration> signatures;
    private final ConcurrentHashMap<JWSAlgorithm, List<SignatureConfiguration>> sortedSignaturesMap = new ConcurrentHashMap();

    public NimbusJsonWebTokenSignatureValidator(List<SignatureConfiguration> signatures) {
        this.signatures = signatures;
    }

    @Override
    public boolean validateSignature(@NonNull SignedJWT signedToken) {
        List sortedSignatures = this.sortedSignaturesMap.computeIfAbsent(signedToken.getHeader().getAlgorithm(), alg -> {
            ArrayList<SignatureConfiguration> sortedConfigs = new ArrayList<SignatureConfiguration>(this.signatures);
            sortedConfigs.sort(NimbusJsonWebTokenSignatureValidator.comparator(alg));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sorted signature configurations for algorithm {} : {}", alg, sortedConfigs);
            }
            return sortedConfigs;
        });
        return NimbusJsonWebTokenSignatureValidator.validate(signedToken, sortedSignatures);
    }

    private static boolean validate(SignedJWT jwt, SignatureConfiguration signatureConfiguration) {
        block4: {
            try {
                boolean verified = signatureConfiguration.verify(jwt);
                if (verified) {
                    return true;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("JWT Signature verification failed: {}", (Object)jwt.getParsedString());
                }
            }
            catch (JOSEException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("Verification failed with signature configuration: {}, passing to the next one", (Object)signatureConfiguration);
            }
        }
        return false;
    }

    private static boolean validate(SignedJWT jwt, List<SignatureConfiguration> signatureConfigurations) {
        for (SignatureConfiguration config : signatureConfigurations) {
            if (!NimbusJsonWebTokenSignatureValidator.validate(jwt, config)) continue;
            return true;
        }
        return false;
    }

    private static Comparator<SignatureConfiguration> comparator(JWSAlgorithm algorithm) {
        return (sig, otherSig) -> {
            boolean otherSupports;
            boolean supports = sig.supports(algorithm);
            if (supports == (otherSupports = otherSig.supports(algorithm))) {
                return 0;
            }
            if (supports) {
                return -1;
            }
            return 1;
        };
    }
}

