/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.generator.claims;

import com.nimbusds.jwt.JWTClaimsSet;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.config.TokenConfiguration;
import io.micronaut.security.token.jwt.generator.claims.ClaimsAudienceProvider;
import io.micronaut.security.token.jwt.generator.claims.ClaimsGenerator;
import io.micronaut.security.token.jwt.generator.claims.JwtIdGenerator;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JWTClaimsSetGenerator
implements ClaimsGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(JWTClaimsSetGenerator.class);
    private static final String ROLES_KEY = "rolesKey";
    private final TokenConfiguration tokenConfiguration;
    private final JwtIdGenerator jwtIdGenerator;
    private final ClaimsAudienceProvider claimsAudienceProvider;
    private final String appName;

    public JWTClaimsSetGenerator(TokenConfiguration tokenConfiguration, @Nullable JwtIdGenerator jwtIdGenerator, @Nullable ClaimsAudienceProvider claimsAudienceProvider, @Nullable ApplicationConfiguration applicationConfiguration) {
        this.tokenConfiguration = tokenConfiguration;
        this.jwtIdGenerator = jwtIdGenerator;
        this.claimsAudienceProvider = claimsAudienceProvider;
        this.appName = applicationConfiguration != null ? applicationConfiguration.getName().orElse("micronaut") : "micronaut";
    }

    @Override
    public Map<String, Object> generateClaims(Authentication authentication, @Nullable Integer expiration) {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        this.populateIat(builder);
        this.populateExp(builder, expiration);
        this.populateJti(builder);
        this.populateIss(builder);
        this.populateAud(builder);
        this.populateNbf(builder);
        this.populateWithAuthentication(builder, authentication);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated claim set: {}", (Object)builder.build().toJSONObject());
        }
        return builder.build().getClaims();
    }

    protected void populateIss(JWTClaimsSet.Builder builder) {
        if (this.appName != null) {
            builder.issuer(this.appName);
        }
    }

    protected void populateSub(JWTClaimsSet.Builder builder, Authentication authentication) {
        builder.subject(authentication.getName());
    }

    protected void populateAud(JWTClaimsSet.Builder builder) {
        if (this.claimsAudienceProvider != null) {
            builder.audience(this.claimsAudienceProvider.audience());
        }
    }

    protected void populateExp(JWTClaimsSet.Builder builder, @Nullable Integer expiration) {
        if (expiration != null) {
            LOG.debug("Setting expiration to {}", (Object)expiration);
            builder.expirationTime(Date.from(Instant.now().plus((long)expiration.intValue(), ChronoUnit.SECONDS)));
        }
    }

    protected void populateNbf(JWTClaimsSet.Builder builder) {
        builder.notBeforeTime(new Date());
    }

    protected void populateIat(JWTClaimsSet.Builder builder) {
        builder.issueTime(new Date());
    }

    protected void populateJti(JWTClaimsSet.Builder builder) {
        if (this.jwtIdGenerator != null) {
            builder.jwtID(this.jwtIdGenerator.generateJtiClaim());
        }
    }

    protected void populateWithAuthentication(JWTClaimsSet.Builder builder, Authentication authentication) {
        this.populateSub(builder, authentication);
        authentication.getAttributes().forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)builder).claim(arg_0, arg_1));
        String rolesKey = this.tokenConfiguration.getRolesName();
        if (!rolesKey.equalsIgnoreCase("roles")) {
            builder.claim(ROLES_KEY, (Object)rolesKey);
        }
        builder.claim(rolesKey, (Object)authentication.getRoles());
    }

    @Override
    public Map<String, Object> generateClaimsSet(Map<String, ?> oldClaims, Integer expiration) {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        List<String> excludedClaims = Arrays.asList("exp", "iat", "nbf");
        for (String k : oldClaims.keySet().stream().filter(p -> !excludedClaims.contains(p)).collect(Collectors.toList())) {
            builder.claim(k, oldClaims.get(k));
        }
        this.populateExp(builder, expiration);
        this.populateIat(builder);
        this.populateNbf(builder);
        return builder.build().getClaims();
    }
}

