/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.validator;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.token.jwt.generator.claims.JwtClaims;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.JwtClaimsValidatorConfiguration;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="micronaut.security.token.jwt.claims-validators.issuer")
public class IssuerJwtClaimsValidator
implements GenericJwtClaimsValidator {
    public static final String ISSUER_PROP = "micronaut.security.token.jwt.claims-validators.issuer";
    private static final Logger LOG = LoggerFactory.getLogger(IssuerJwtClaimsValidator.class);
    @Nullable
    private final String expectedIssuer;

    public IssuerJwtClaimsValidator(JwtClaimsValidatorConfiguration jwtClaimsValidatorConfiguration) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing IssuerJwtClaimsValidator with issuer: {}", (Object)jwtClaimsValidatorConfiguration.getIssuer());
        }
        this.expectedIssuer = jwtClaimsValidatorConfiguration.getIssuer();
    }

    @Override
    public boolean validate(@NonNull JwtClaims claims, @Nullable HttpRequest<?> request) {
        if (this.expectedIssuer == null) {
            return true;
        }
        Object issuerObject = claims.get("iss");
        if (issuerObject == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Expected JWT issuer claim of '{}', but the token did not include an issuer.", (Object)this.expectedIssuer);
            }
            return false;
        }
        if (!this.expectedIssuer.equals(issuerObject.toString())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Expected JWT issuer claim of '{}', but found '{}' instead.", (Object)this.expectedIssuer, issuerObject);
            }
            return false;
        }
        return true;
    }
}

