/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.cookie;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.cookie.SameSite;
import io.micronaut.security.authentication.CookieBasedAuthenticationModeCondition;
import io.micronaut.security.token.jwt.cookie.AbstractAccessTokenCookieConfigurationProperties;
import io.micronaut.security.token.jwt.cookie.RefreshTokenCookieConfiguration;
import java.util.Optional;

@Requirements(value={@Requires(condition=CookieBasedAuthenticationModeCondition.class), @Requires(property="micronaut.security.token.refresh.cookie.enabled", notEquals="false", defaultValue="true")})
@ConfigurationProperties(value="micronaut.security.token.refresh.cookie")
public class RefreshTokenCookieConfigurationProperties
extends AbstractAccessTokenCookieConfigurationProperties
implements RefreshTokenCookieConfiguration {
    public static final String PREFIX = "micronaut.security.token.refresh.cookie";
    public static final boolean DEFAULT_ENABLED = true;
    @Deprecated
    public static final boolean DEFAULT_HTTPONLY = true;
    public static final String DEFAULT_COOKIENAME = "JWT_REFRESH_TOKEN";
    public static final String DEFAULT_COOKIEPATH = "/oauth/access_token";
    @Deprecated
    public static final SameSite DEFAULT_COOKIESAMESITE = AbstractAccessTokenCookieConfigurationProperties.DEFAULT_COOKIESAMESITE;
    private String cookiePath = "/oauth/access_token";
    private boolean enabled = true;
    private String cookieName = "JWT_REFRESH_TOKEN";

    public RefreshTokenCookieConfigurationProperties(@Nullable @Property(name="micronaut.security.endpoints.oauth.path") String oauthControllerPath) {
        if (oauthControllerPath != null) {
            this.cookiePath = oauthControllerPath;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @NonNull
    public String getCookieName() {
        return this.cookieName;
    }

    @Nullable
    public Optional<String> getCookiePath() {
        return Optional.ofNullable(this.cookiePath);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public void setCookiePath(@Nullable String cookiePath) {
        this.cookiePath = cookiePath;
    }
}

