/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.encryption;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.security.token.jwt.encryption.EncryptionConfiguration;
import java.text.ParseException;

public abstract class AbstractEncryptionConfiguration
implements EncryptionConfiguration {
    protected JWEAlgorithm algorithm;
    protected EncryptionMethod method;

    @Override
    public String encrypt(JWT jwt) throws JOSEException, ParseException {
        if (jwt instanceof SignedJWT) {
            JWEObject jweObject = new JWEObject(new JWEHeader.Builder(this.algorithm, this.method).contentType("JWT").build(), new Payload((SignedJWT)jwt));
            jweObject.encrypt(this.buildEncrypter());
            return jweObject.serialize();
        }
        JWEHeader header = new JWEHeader(this.algorithm, this.method);
        EncryptedJWT encryptedJwt = new EncryptedJWT(header, jwt.getJWTClaimsSet());
        encryptedJwt.encrypt(this.buildEncrypter());
        return encryptedJwt.serialize();
    }

    protected abstract JWEEncrypter buildEncrypter() throws JOSEException;

    @Override
    public void decrypt(EncryptedJWT encryptedJWT) throws JOSEException {
        encryptedJWT.decrypt(this.buildDecrypter());
    }

    protected abstract JWEDecrypter buildDecrypter() throws JOSEException;

    public JWEAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(JWEAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public EncryptionMethod getMethod() {
        return this.method;
    }

    public void setMethod(EncryptionMethod method) {
        this.method = method;
    }
}

