/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.validator;

import com.nimbusds.jwt.JWTClaimsSet;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.token.jwt.generator.claims.JwtClaims;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.JWTClaimsSetUtils;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="micronaut.security.token.jwt.claims-validators.subject-not-null", notEquals="false")
public class SubjectNotNullJwtClaimsValidator
implements GenericJwtClaimsValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SubjectNotNullJwtClaimsValidator.class);

    public boolean validate(JWTClaimsSet claimsSet) {
        boolean hasSubject;
        String subject = claimsSet.getSubject();
        boolean bl = hasSubject = subject != null;
        if (!hasSubject && LOG.isDebugEnabled()) {
            LOG.debug("JWT must contain a subject ('sub' claim)");
        }
        return hasSubject;
    }

    @Override
    public boolean validate(@NonNull JwtClaims claims, @Nullable HttpRequest<?> request) {
        return this.validate(JWTClaimsSetUtils.jwtClaimsSetFromClaims(claims));
    }
}

