/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.encryption.secret;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.AESDecrypter;
import com.nimbusds.jose.crypto.AESEncrypter;
import com.nimbusds.jose.crypto.DirectDecrypter;
import com.nimbusds.jose.crypto.DirectEncrypter;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.security.token.jwt.encryption.AbstractEncryptionConfiguration;
import io.micronaut.security.token.jwt.encryption.secret.SecretEncryptionConfiguration;
import java.nio.charset.StandardCharsets;

public class SecretEncryption
extends AbstractEncryptionConfiguration {
    private byte[] secret;

    public SecretEncryption(SecretEncryptionConfiguration secretEncryptionConfiguration) {
        if (secretEncryptionConfiguration.getSecret() == null) {
            throw new ConfigurationException("Secret encryption Configuration 'secret' is required");
        }
        if (!this.supports(secretEncryptionConfiguration.getJweAlgorithm(), secretEncryptionConfiguration.getEncryptionMethod())) {
            StringBuilder sb = new StringBuilder();
            sb.append("Encryption Method: ");
            sb.append(secretEncryptionConfiguration.getEncryptionMethod().toString());
            sb.append("JWE Algorithm: ");
            sb.append(secretEncryptionConfiguration.getJweAlgorithm().getName());
            sb.append(" not supported for Secret encryption");
            throw new ConfigurationException(sb.toString());
        }
        this.secret = secretEncryptionConfiguration.getSecret().getBytes(StandardCharsets.UTF_8);
        this.method = secretEncryptionConfiguration.getEncryptionMethod();
        this.algorithm = secretEncryptionConfiguration.getJweAlgorithm();
    }

    @Override
    public boolean supports(JWEAlgorithm algorithm, EncryptionMethod method) {
        if (algorithm != null && method != null) {
            boolean isDirect = DirectDecrypter.SUPPORTED_ALGORITHMS.contains(algorithm) && DirectDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(method);
            boolean isAes = AESDecrypter.SUPPORTED_ALGORITHMS.contains(algorithm) && AESDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(method);
            return isDirect || isAes;
        }
        return false;
    }

    @Override
    public String supportedAlgorithmsMessage() {
        return "Only the direct and AES algorithms are supported with the appropriate encryption method";
    }

    @Override
    protected JWEEncrypter buildEncrypter() throws KeyLengthException {
        if (DirectDecrypter.SUPPORTED_ALGORITHMS.contains(this.algorithm)) {
            return new DirectEncrypter(this.secret);
        }
        return new AESEncrypter(this.secret);
    }

    @Override
    protected JWEDecrypter buildDecrypter() throws KeyLengthException {
        if (DirectDecrypter.SUPPORTED_ALGORITHMS.contains(this.algorithm)) {
            return new DirectDecrypter(this.secret);
        }
        return new AESDecrypter(this.secret);
    }

    public String getSecret() {
        return new String(this.secret, StandardCharsets.UTF_8);
    }

    public void setSecret(String secret) {
        this.secret = secret.getBytes(StandardCharsets.UTF_8);
    }
}

