/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.endpoints;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.jwk.JWKSet;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.token.jwt.endpoints.JwkProvider;
import java.util.Collection;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Requirements(value={@Requires(property="micronaut.security.endpoints.keys.enabled", notEquals="false", defaultValue="true"), @Requires(beans={JwkProvider.class})})
@Controller(value="${micronaut.security.endpoints.keys.path:/keys}")
@Secured(value={"isAnonymous()"})
public class KeysController {
    private static final Logger LOG = LoggerFactory.getLogger(KeysController.class);
    private static final String EMPTY_KEYS = "{\"keys\": []}";
    private final Collection<JwkProvider> jwkProviders;
    private final ObjectMapper objectMapper;

    public KeysController(Collection<JwkProvider> jwkProviders, ObjectMapper objectMapper) {
        this.jwkProviders = jwkProviders;
        this.objectMapper = objectMapper.copy().setSerializationInclusion(JsonInclude.Include.ALWAYS);
    }

    @Get
    @SingleResult
    public Publisher<String> keys() {
        if (this.jwkProviders.isEmpty()) {
            return Mono.just((Object)EMPTY_KEYS);
        }
        return Flux.fromIterable(this.jwkProviders).flatMapIterable(JwkProvider::retrieveJsonWebKeys).collectList().map(JWKSet::new).map(JWKSet::toJSONObject).map(m -> {
            try {
                return this.objectMapper.writeValueAsString(m);
            }
            catch (JsonProcessingException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("JSON Processing exception getting JSON representation of the JSON Web Key sets");
                }
                return EMPTY_KEYS;
            }
        });
    }
}

