/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.generator;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.BeanContext;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.token.event.AccessTokenGeneratedEvent;
import io.micronaut.security.token.event.RefreshTokenGeneratedEvent;
import io.micronaut.security.token.generator.RefreshTokenGenerator;
import io.micronaut.security.token.generator.TokenGenerator;
import io.micronaut.security.token.jwt.generator.AccessRefreshTokenGenerator;
import io.micronaut.security.token.jwt.generator.AccessTokenConfiguration;
import io.micronaut.security.token.jwt.generator.claims.ClaimsGenerator;
import io.micronaut.security.token.jwt.render.AccessRefreshToken;
import io.micronaut.security.token.jwt.render.TokenRenderer;
import io.micronaut.security.token.refresh.RefreshTokenPersistence;
import io.micronaut.security.token.validator.RefreshTokenValidator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultAccessRefreshTokenGenerator
implements AccessRefreshTokenGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(AccessRefreshTokenGenerator.class);
    protected final BeanContext beanContext;
    protected final RefreshTokenGenerator refreshTokenGenerator;
    protected final ClaimsGenerator claimsGenerator;
    protected final AccessTokenConfiguration accessTokenConfiguration;
    protected final TokenRenderer tokenRenderer;
    protected final TokenGenerator tokenGenerator;
    protected final ApplicationEventPublisher eventPublisher;

    public DefaultAccessRefreshTokenGenerator(AccessTokenConfiguration accessTokenConfiguration, TokenRenderer tokenRenderer, TokenGenerator tokenGenerator, BeanContext beanContext, @Nullable RefreshTokenGenerator refreshTokenGenerator, ClaimsGenerator claimsGenerator, ApplicationEventPublisher eventPublisher) {
        this.accessTokenConfiguration = accessTokenConfiguration;
        this.tokenRenderer = tokenRenderer;
        this.tokenGenerator = tokenGenerator;
        this.beanContext = beanContext;
        this.refreshTokenGenerator = refreshTokenGenerator;
        this.claimsGenerator = claimsGenerator;
        this.eventPublisher = eventPublisher;
    }

    @Override
    @NonNull
    public Optional<AccessRefreshToken> generate(@NonNull UserDetails userDetails) {
        return this.generate((String)this.generateRefreshToken(userDetails).orElse(null), userDetails);
    }

    @Override
    @NonNull
    public Optional<String> generateRefreshToken(@NonNull UserDetails userDetails) {
        Optional refreshToken = Optional.empty();
        if (this.beanContext.containsBean(RefreshTokenValidator.class)) {
            if (this.beanContext.containsBean(RefreshTokenPersistence.class)) {
                if (this.refreshTokenGenerator != null) {
                    String key = this.refreshTokenGenerator.createKey(userDetails);
                    refreshToken = this.refreshTokenGenerator.generate(userDetails, key);
                    refreshToken.ifPresent(t -> this.eventPublisher.publishEvent((Object)new RefreshTokenGeneratedEvent(userDetails, key)));
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Skipped refresh token generation because no {} implementation is present", (Object)RefreshTokenGenerator.class.getName());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Skipped refresh token generation because no {} implementation is present", (Object)RefreshTokenPersistence.class.getName());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Skipped refresh token generation because no {} implementation is present", (Object)RefreshTokenValidator.class.getName());
        }
        return refreshToken;
    }

    @Override
    @NonNull
    public Optional<AccessRefreshToken> generate(@NonNull String refreshToken, @NonNull Map<String, ?> oldClaims) {
        Map<String, Object> claims = this.claimsGenerator.generateClaimsSet(oldClaims, this.accessTokenExpiration(oldClaims));
        Optional optionalAccessToken = this.tokenGenerator.generateToken(claims);
        if (!optionalAccessToken.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("tokenGenerator failed to generate access token claims: {}", (Object)claims.entrySet().stream().map(entry -> (String)entry.getKey() + "=>" + entry.getValue().toString()).collect(Collectors.joining(", ")));
            }
            return Optional.empty();
        }
        String accessToken = (String)optionalAccessToken.get();
        this.eventPublisher.publishEvent((Object)new AccessTokenGeneratedEvent((Object)accessToken));
        return Optional.of(this.tokenRenderer.render(this.accessTokenExpiration(oldClaims), accessToken, refreshToken));
    }

    @Override
    @NonNull
    public Optional<AccessRefreshToken> generate(@NonNull String refreshToken, @NonNull UserDetails userDetails) {
        Optional optionalAccessToken = this.tokenGenerator.generateToken(userDetails, this.accessTokenExpiration(userDetails));
        if (!optionalAccessToken.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to generate access token for user {}", (Object)userDetails.getUsername());
            }
            return Optional.empty();
        }
        String accessToken = (String)optionalAccessToken.get();
        this.eventPublisher.publishEvent((Object)new AccessTokenGeneratedEvent((Object)accessToken));
        return Optional.of(this.tokenRenderer.render(userDetails, this.accessTokenExpiration(userDetails), accessToken, refreshToken));
    }

    @NonNull
    public Integer accessTokenExpiration(@NonNull UserDetails userDetails) {
        return this.accessTokenConfiguration.getExpiration();
    }

    @NonNull
    public Integer accessTokenExpiration(@NonNull Map<String, ?> oldClaims) {
        return this.accessTokenConfiguration.getExpiration();
    }
}

