/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.csrf.session;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.csrf.CsrfConfiguration;
import io.micronaut.security.csrf.repository.CsrfTokenRepository;
import io.micronaut.session.http.SessionForRequest;
import jakarta.inject.Singleton;
import java.util.Optional;

@Requirements(value={@Requires(classes={HttpRequest.class}), @Requires(beans={CsrfConfiguration.class}), @Requires(property="micronaut.security.csrf.repositories.session.enabled", value="true", defaultValue="true")})
@Singleton
public class SessionCsrfTokenRepository
implements CsrfTokenRepository<HttpRequest<?>> {
    private final CsrfConfiguration csrfConfiguration;

    public SessionCsrfTokenRepository(CsrfConfiguration csrfConfiguration) {
        this.csrfConfiguration = csrfConfiguration;
    }

    @Override
    @NonNull
    public Optional<String> findCsrfToken(@NonNull HttpRequest<?> request) {
        return SessionForRequest.find(request).flatMap(session -> session.get((CharSequence)this.csrfConfiguration.getHttpSessionName(), String.class));
    }
}

