/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.csrf.resolver;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.csrf.resolver.CsrfTokenResolver;
import io.micronaut.security.csrf.resolver.FutureCsrfTokenResolver;
import java.util.concurrent.CompletableFuture;

final class FutureCsrfTokenResolverAdapter<T>
implements FutureCsrfTokenResolver<T> {
    private final CsrfTokenResolver<T> csrfTokenResolver;

    public FutureCsrfTokenResolverAdapter(CsrfTokenResolver<T> csrfTokenResolver) {
        this.csrfTokenResolver = csrfTokenResolver;
    }

    @Override
    @NonNull
    public CompletableFuture<String> resolveToken(@NonNull T request) {
        return CompletableFuture.completedFuture(this.csrfTokenResolver.resolveToken(request).orElse(null));
    }

    public int getOrder() {
        return this.csrfTokenResolver.getOrder();
    }
}

