/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.csrf.resolver;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.ServerHttpRequest;
import io.micronaut.http.server.filter.FilterBodyParser;
import io.micronaut.security.csrf.CsrfConfiguration;
import io.micronaut.security.csrf.resolver.FutureCsrfTokenResolver;
import jakarta.inject.Singleton;
import java.util.concurrent.CompletableFuture;

@Requirements(value={@Requires(classes={HttpRequest.class}), @Requires(property="micronaut.security.csrf.token-resolvers.field.enabled", value="true", defaultValue="true")})
@Singleton
final class FieldCsrfTokenResolver
implements FutureCsrfTokenResolver<HttpRequest<?>> {
    private final CsrfConfiguration csrfConfiguration;
    private final FilterBodyParser filterBodyParser;

    FieldCsrfTokenResolver(CsrfConfiguration csrfConfiguration, FilterBodyParser filterBodyParser) {
        this.csrfConfiguration = csrfConfiguration;
        this.filterBodyParser = filterBodyParser;
    }

    @Override
    @NonNull
    public CompletableFuture<String> resolveToken(@NonNull HttpRequest<?> request) {
        if (request instanceof ServerHttpRequest) {
            ServerHttpRequest serverHttpRequest = (ServerHttpRequest)request;
            return this.resolveToken(serverHttpRequest);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    private CompletableFuture<String> resolveToken(ServerHttpRequest<?> request) {
        return this.filterBodyParser.parseBody(request).thenApply(m -> {
            Object csrfToken = m.get(this.csrfConfiguration.getFieldName());
            return csrfToken == null || StringUtils.isEmpty((CharSequence)csrfToken.toString()) ? null : csrfToken.toString();
        });
    }
}

