/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.csrf.session;

import io.micronaut.core.annotation.Internal;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.csrf.CsrfConfiguration;
import io.micronaut.security.csrf.generator.CsrfTokenGenerator;
import io.micronaut.security.session.SessionPopulator;
import io.micronaut.session.Session;
import jakarta.inject.Singleton;

@Singleton
@Internal
final class CsrfSessionPopulator<T>
implements SessionPopulator<T> {
    private final CsrfConfiguration csrfConfiguration;
    private final CsrfTokenGenerator<T> csrfTokenGenerator;

    public CsrfSessionPopulator(CsrfConfiguration csrfConfiguration, CsrfTokenGenerator<T> csrfTokenGenerator) {
        this.csrfConfiguration = csrfConfiguration;
        this.csrfTokenGenerator = csrfTokenGenerator;
    }

    public void populateSession(T request, Authentication authentication, Session session) {
        session.put((CharSequence)this.csrfConfiguration.getHttpSessionName(), (Object)this.csrfTokenGenerator.generateCsrfToken(request));
    }
}

