/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.csrf.repository;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.security.csrf.CsrfConfiguration;
import io.micronaut.security.csrf.generator.CsrfTokenGenerator;
import io.micronaut.security.token.cookie.LoginCookieProvider;
import jakarta.inject.Singleton;

@Requires(classes={HttpRequest.class})
@Singleton
public class CsrfLoginCookieProvider
implements LoginCookieProvider<HttpRequest<?>> {
    private final CsrfTokenGenerator<HttpRequest<?>> csrfTokenGenerator;
    private final CsrfConfiguration csrfConfiguration;

    public CsrfLoginCookieProvider(CsrfTokenGenerator<HttpRequest<?>> csrfTokenGenerator, CsrfConfiguration csrfConfiguration) {
        this.csrfTokenGenerator = csrfTokenGenerator;
        this.csrfConfiguration = csrfConfiguration;
    }

    @NonNull
    public Cookie provideCookie(@NonNull HttpRequest<?> request) {
        String csrfToken = this.csrfTokenGenerator.generateCsrfToken(request);
        Cookie cookie = Cookie.of((String)this.csrfConfiguration.getCookieName(), (String)csrfToken);
        cookie.configure((CookieConfiguration)this.csrfConfiguration, request.isSecure());
        return cookie;
    }
}

