/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.csrf.validator;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.security.csrf.generator.CsrfHmacTokenGenerator;
import io.micronaut.security.csrf.repository.CsrfTokenRepository;
import io.micronaut.security.csrf.validator.CsrfTokenValidator;
import jakarta.inject.Singleton;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(beans={CsrfTokenRepository.class, CsrfHmacTokenGenerator.class})
@Internal
@Singleton
class RepositoryCsrfTokenValidator<T>
implements CsrfTokenValidator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryCsrfTokenValidator.class);
    private final List<CsrfTokenRepository<T>> repositories;
    private final CsrfHmacTokenGenerator<T> defaultCsrfTokenGenerator;

    public RepositoryCsrfTokenValidator(List<CsrfTokenRepository<T>> repositories, CsrfHmacTokenGenerator<T> defaultCsrfTokenGenerator) {
        this.repositories = repositories;
        this.defaultCsrfTokenGenerator = defaultCsrfTokenGenerator;
    }

    @Override
    public boolean validateCsrfToken(T request, String csrfTokenInRequest) {
        for (CsrfTokenRepository<T> repo : this.repositories) {
            String csrfTokenInRepository;
            Optional<String> csrfTokenOptional = repo.findCsrfToken(request);
            if (!csrfTokenOptional.isPresent() || !(csrfTokenInRepository = csrfTokenOptional.get()).equals(csrfTokenInRequest) || !this.validateHmac(request, csrfTokenInRequest)) continue;
            return true;
        }
        return false;
    }

    private boolean validateHmac(T request, String csrfTokenInRequest) {
        String[] arr = csrfTokenInRequest.split("\\.");
        if (arr.length != 2) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Invalid CSRF token: {}", (Object)csrfTokenInRequest);
            }
            return false;
        }
        String hmac = arr[0];
        String randomValue = arr[1];
        String expectedHmac = this.defaultCsrfTokenGenerator.hmac(request, randomValue);
        return MessageDigest.isEqual(expectedHmac.getBytes(StandardCharsets.UTF_8), hmac.getBytes(StandardCharsets.UTF_8));
    }
}

