/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.csrf.filter;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.util.PathMatcher;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.filter.FilterPatternStyle;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthorizationException;
import io.micronaut.security.csrf.filter.CsrfFilterConfiguration;
import io.micronaut.security.csrf.resolver.CsrfTokenResolver;
import io.micronaut.security.csrf.resolver.FutureCsrfTokenResolver;
import io.micronaut.security.csrf.validator.CsrfTokenValidator;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.UriRouteMatch;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Requirements(value={@Requires(property="micronaut.security.csrf.filter.enabled", value="true", defaultValue="true"), @Requires(classes={ExceptionHandler.class, HttpRequest.class}), @Requires(beans={CsrfTokenValidator.class})})
@ServerFilter(patternStyle=FilterPatternStyle.REGEX, value={"${micronaut.security.csrf.filter.regex-pattern:^.*$}"})
final class CsrfFilter
implements Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(CsrfFilter.class);
    private static final CompletableFuture<@Nullable HttpResponse<?>> PROCEED = CompletableFuture.completedFuture(null);
    private final List<FutureCsrfTokenResolver<HttpRequest<?>>> futureCsrfTokenResolvers;
    private final List<CsrfTokenResolver<HttpRequest<?>>> csrfTokenResolvers;
    private final CsrfTokenValidator<HttpRequest<?>> csrfTokenValidator;
    private final ExceptionHandler<AuthorizationException, MutableHttpResponse<?>> exceptionHandler;
    private final CsrfFilterConfiguration csrfFilterConfiguration;

    CsrfFilter(CsrfFilterConfiguration csrfFilterConfiguration, List<FutureCsrfTokenResolver<HttpRequest<?>>> futureCsrfTokenResolvers, List<CsrfTokenResolver<HttpRequest<?>>> csrfTokenResolvers, CsrfTokenValidator<HttpRequest<?>> csrfTokenValidator, ExceptionHandler<AuthorizationException, MutableHttpResponse<?>> exceptionHandler) {
        this.csrfTokenResolvers = csrfTokenResolvers;
        this.futureCsrfTokenResolvers = futureCsrfTokenResolvers.isEmpty() ? futureCsrfTokenResolvers : FutureCsrfTokenResolver.of(csrfTokenResolvers, futureCsrfTokenResolvers);
        this.csrfTokenValidator = csrfTokenValidator;
        this.exceptionHandler = exceptionHandler;
        this.csrfFilterConfiguration = csrfFilterConfiguration;
    }

    @RequestFilter
    @Nullable
    public @Nullable CompletableFuture<@Nullable HttpResponse<?>> csrfFilter(@NonNull HttpRequest<?> request) {
        if (!this.shouldTheFilterProcessTheRequestAccordingToTheUriMatch(request)) {
            return PROCEED;
        }
        if (!this.shouldTheFilterProcessTheRequestAccordingToTheHttpMethod(request)) {
            return PROCEED;
        }
        if (!this.shouldTheFilterProcessTheRequestAccordingToTheContentType(request)) {
            return PROCEED;
        }
        return this.futureCsrfTokenResolvers.isEmpty() ? this.imperativeFilter(request) : this.reactiveFilter(request);
    }

    boolean shouldTheFilterProcessTheRequestAccordingToTheUriMatch(HttpRequest<?> request) {
        RouteMatch routeMatch = request.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, RouteMatch.class).orElse(null);
        if (routeMatch instanceof UriRouteMatch) {
            UriRouteMatch uriRouteMatch = (UriRouteMatch)routeMatch;
            return this.shouldTheFilterProcessTheRequestAccordingToTheUriMatch(uriRouteMatch);
        }
        return true;
    }

    boolean shouldTheFilterProcessTheRequestAccordingToTheUriMatch(UriRouteMatch<?, ?> uriRouteMatch) {
        return this.shouldTheFilterProcessTheRequestAccordingToTheUriMatch(uriRouteMatch.getUri());
    }

    boolean shouldTheFilterProcessTheRequestAccordingToTheUriMatch(String uri) {
        boolean matches = PathMatcher.REGEX.matches(this.csrfFilterConfiguration.getRegexPattern(), uri);
        if (!matches) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Request uri {} does not match fitler regex pattern {}", (Object)uri, (Object)this.csrfFilterConfiguration.getRegexPattern());
            }
            return false;
        }
        return true;
    }

    private CompletableFuture<@Nullable HttpResponse<?>> reactiveFilter(HttpRequest<?> request) {
        List<CompletableFuture> futures = this.futureCsrfTokenResolvers.stream().map(resolver -> resolver.resolveToken(request).thenApply(csrfToken -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace("CSRF Token resolved");
            }
            return this.csrfTokenValidator.validateCsrfToken(request, (String)csrfToken);
        })).toList();
        CompletableFuture[] futuresArray = futures.toArray(new CompletableFuture[0]);
        return ((CompletableFuture)CompletableFuture.allOf(futuresArray).thenApply(v -> futures.stream().map(CompletableFuture::join).toList())).thenApply(validations -> {
            if (validations.stream().anyMatch(Boolean::booleanValue)) {
                return null;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("CSRF Token validation failed");
            }
            return this.unauthorized(request);
        });
    }

    private CompletableFuture<@Nullable HttpResponse<?>> imperativeFilter(HttpRequest<?> request) {
        String csrfToken = this.resolveCsrfToken(request);
        if (StringUtils.isEmpty((CharSequence)csrfToken)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Request rejected by the {} because no CSRF Token found", (Object)this.getClass().getSimpleName());
            }
            return this.reactiveUnauthorized(request);
        }
        if (this.csrfTokenValidator.validateCsrfToken(request, csrfToken)) {
            return PROCEED;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request rejected by the CSRF Filter because the CSRF Token validation failed");
        }
        return this.reactiveUnauthorized(request);
    }

    private boolean shouldTheFilterProcessTheRequestAccordingToTheContentType(@NonNull HttpRequest<?> request) {
        MediaType contentType = request.getContentType().orElse(null);
        if (contentType != null && this.csrfFilterConfiguration.getContentTypes().stream().noneMatch(method -> method.equals((Object)contentType))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Request {} {} with content type {} is not processed by the CSRF filter. CSRF filter only processes Content Types: {}", new Object[]{request.getMethod(), request.getPath(), contentType, this.csrfFilterConfiguration.getContentTypes().stream().map(MediaType::toString).toList()});
            }
            return false;
        }
        return true;
    }

    private boolean shouldTheFilterProcessTheRequestAccordingToTheHttpMethod(@NonNull HttpRequest<?> request) {
        if (this.csrfFilterConfiguration.getMethods().stream().noneMatch(method -> method.equals((Object)request.getMethod()))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Request {} {} not processed by the CSRF filter. CSRF filter only processes HTTP Methods: {}", new Object[]{request.getMethod(), request.getPath(), this.csrfFilterConfiguration.getMethods().stream().map(Enum::name).toList()});
            }
            return false;
        }
        return true;
    }

    @Nullable
    private String resolveCsrfToken(@NonNull HttpRequest<?> request) {
        for (CsrfTokenResolver<HttpRequest<?>> tokenResolver : this.csrfTokenResolvers) {
            Optional<String> tokenOptional = tokenResolver.resolveToken(request);
            if (!tokenOptional.isPresent()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("CSRF token resolved via {}", (Object)tokenResolver.getClass().getSimpleName());
            }
            return tokenOptional.get();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("No CSRF token found in request");
        }
        return null;
    }

    private @NonNull CompletableFuture<@Nullable HttpResponse<?>> reactiveUnauthorized(@NonNull HttpRequest<?> request) {
        return CompletableFuture.completedFuture(this.unauthorized(request));
    }

    @NonNull
    private MutableHttpResponse<?> unauthorized(@NonNull HttpRequest<?> request) {
        Authentication authentication = request.getAttribute(SecurityFilter.AUTHENTICATION, Authentication.class).orElse(null);
        return (MutableHttpResponse)this.exceptionHandler.handle(request, (Throwable)new AuthorizationException(authentication));
    }

    public int getOrder() {
        return ServerFilterPhase.SECURITY.order() + 100;
    }
}

