/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.aot;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.codegen.AbstractCodeGenerator;
import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.aot.AOTContextUtils;
import io.micronaut.security.aot.GeneratedFile;
import io.micronaut.security.oauth2.client.DefaultOpenIdProviderMetadata;
import io.micronaut.security.oauth2.client.DefaultOpenIdProviderMetadataFetcher;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadataFetcher;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AOTModule(id="micronaut.security.openid-configuration")
public class OpenIdProviderMetadataFetcherCodeGenerator
extends AbstractCodeGenerator {
    public static final String SECURITY_AOT_OPENID_CONFIGURATION_MODULE_ID = "micronaut.security.openid-configuration";
    private static final Logger LOG = LoggerFactory.getLogger(OpenIdProviderMetadataFetcherCodeGenerator.class);
    private static final ParameterizedTypeName SUPPLIER_OF_METADATA = ParameterizedTypeName.get(Supplier.class, (Type[])new Type[]{DefaultOpenIdProviderMetadata.class});
    private static final String BUILDER = "builder.";

    public void generate(@NonNull AOTContext context) {
        List<GeneratedFile> files = this.generateJavaFiles(context);
        if (!files.isEmpty()) {
            context.registerStaticOptimization("AotOpenIdProviderMetadataFetcherCode", DefaultOpenIdProviderMetadataFetcher.Optimizations.class, body -> {
                body.addStatement("$T configs = new $T()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), SUPPLIER_OF_METADATA}), ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{TypeName.get(String.class), SUPPLIER_OF_METADATA})});
                for (GeneratedFile f : files) {
                    context.registerGeneratedSourceFile(f.getJavaFile());
                    body.addStatement("configs.put($S, $T::create)", new Object[]{f.getName(), ClassName.bestGuess((String)f.getSimpleName())});
                }
                body.addStatement("return new $T(configs)", new Object[]{DefaultOpenIdProviderMetadataFetcher.Optimizations.class});
            });
        }
    }

    private List<GeneratedFile> generateJavaFiles(@NonNull AOTContext context) {
        Collection<OpenIdClientConfiguration> clientConfigurations = AOTContextUtils.getBeansOfType(OpenIdClientConfiguration.class, context);
        ArrayList<GeneratedFile> files = new ArrayList<GeneratedFile>();
        for (OpenIdClientConfiguration clientConfig : clientConfigurations) {
            Qualifier nameQualifier = Qualifiers.byName((String)clientConfig.getName());
            if (!clientConfig.getIssuer().isPresent() || !AOTContextUtils.containsBean(OpenIdProviderMetadataFetcher.class, nameQualifier, context)) continue;
            OpenIdProviderMetadataFetcher fetcher = AOTContextUtils.getBean(OpenIdProviderMetadataFetcher.class, nameQualifier, context);
            try {
                DefaultOpenIdProviderMetadata defaultOpenIdProviderMetadata = fetcher.fetch();
                String simpleName = this.generatedClassSimpleName(clientConfig);
                files.add(new GeneratedFile(clientConfig.getName(), simpleName, this.generateJavaFile(context, simpleName, defaultOpenIdProviderMetadata)));
            }
            catch (Exception e) {
                LOG.error("Could not generate {} optimizations for OAuth 2.0 Client with qualifier {}", (Object)SECURITY_AOT_OPENID_CONFIGURATION_MODULE_ID, (Object)nameQualifier);
            }
        }
        return files;
    }

    private String generatedClassSimpleName(@NonNull OpenIdClientConfiguration clientConfig) {
        return "Aot" + OpenIdProviderMetadataFetcher.class.getSimpleName() + StringUtils.capitalize((String)clientConfig.getName());
    }

    private JavaFile generateJavaFile(@NonNull AOTContext context, @NonNull String fileSimpleName, @NonNull DefaultOpenIdProviderMetadata defaultOpenIdProviderMetadata) {
        return context.javaFile(TypeSpec.classBuilder((String)fileSimpleName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(this.generateMethod(defaultOpenIdProviderMetadata)).build());
    }

    private MethodSpec generateMethod(@NonNull DefaultOpenIdProviderMetadata defaultOpenIdProviderMetadata) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"create").returns(DefaultOpenIdProviderMetadata.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("$T builder = $T.builder()", new Object[]{DefaultOpenIdProviderMetadata.Builder.class, DefaultOpenIdProviderMetadata.class});
        this.addStringSetterStatement(methodBuilder, "userinfoEndpoint", defaultOpenIdProviderMetadata.getUserinfoEndpoint());
        this.addBooleanSetterStatement(methodBuilder, "requireRequestUriRegistration", defaultOpenIdProviderMetadata.getRequireRequestUriRegistration());
        this.addStringSetterStatement(methodBuilder, "authorizationEndpoint", defaultOpenIdProviderMetadata.getAuthorizationEndpoint());
        this.addListStringSetterStatement(methodBuilder, "userinfoEncryptionEncValuesSupported", "userinfoEncryptionEncValuesSupported", defaultOpenIdProviderMetadata.getUserinfoEncryptionEncValuesSupported());
        this.addListStringSetterStatement(methodBuilder, "idTokenEncryptionEncValuesSupported", "idTokenEncryptionEncValuesSupported", defaultOpenIdProviderMetadata.getIdTokenEncryptionEncValuesSupported());
        this.addListStringSetterStatement(methodBuilder, "userinfoEncryptionAlgValuesSupported", "userinfoEncryptionAlgValuesSupported", defaultOpenIdProviderMetadata.getUserInfoEncryptionAlgValuesSupported());
        this.addListStringSetterStatement(methodBuilder, "idTokenSigningAlgValuesSupported", "idTokenSigningAlgValuesSupported", defaultOpenIdProviderMetadata.getIdTokenSigningAlgValuesSupported());
        this.addStringSetterStatement(methodBuilder, "issuer", defaultOpenIdProviderMetadata.getIssuer());
        this.addStringSetterStatement(methodBuilder, "jwksUri", defaultOpenIdProviderMetadata.getJwksUri());
        this.addListStringSetterStatement(methodBuilder, "responseTypesSupported", "responseTypesSupported", defaultOpenIdProviderMetadata.getResponseTypesSupported());
        this.addListStringSetterStatement(methodBuilder, "scopesSupported", "scopesSupported", defaultOpenIdProviderMetadata.getScopesSupported());
        this.addListStringSetterStatement(methodBuilder, "subjectTypesSupported", "subjectTypesSupported", defaultOpenIdProviderMetadata.getSubjectTypesSupported());
        this.addStringSetterStatement(methodBuilder, "tokenEndpoint", defaultOpenIdProviderMetadata.getTokenEndpoint());
        this.addListStringSetterStatement(methodBuilder, "tokenEndpointAuthSigningAlgValuesSupported", "tokenEndpointAuthSigningAlgValuesSupported", defaultOpenIdProviderMetadata.getTokenEndpointAuthSigningAlgValuesSupported());
        this.addListStringSetterStatement(methodBuilder, "displayValuesSupported", "displayValuesSupported", defaultOpenIdProviderMetadata.getDisplayValuesSupported());
        this.addListStringSetterStatement(methodBuilder, "claimTypesSupported", "claimTypesSupported", defaultOpenIdProviderMetadata.getClaimTypesSupported());
        this.addListStringSetterStatement(methodBuilder, "tokenEndpointAuthMethodsSupported", "tokenEndpointAuthMethodsSupported", defaultOpenIdProviderMetadata.getTokenEndpointAuthMethodsSupported());
        this.addListStringSetterStatement(methodBuilder, "responseModesSupported", "responseModesSupported", defaultOpenIdProviderMetadata.getResponseModesSupported());
        this.addListStringSetterStatement(methodBuilder, "acrValuesSupported", "acrValuesSupported", defaultOpenIdProviderMetadata.getAcrValuesSupported());
        this.addListStringSetterStatement(methodBuilder, "grantTypesSupported", "grantTypesSupported", defaultOpenIdProviderMetadata.getGrantTypesSupported());
        this.addStringSetterStatement(methodBuilder, "registrationEndpoint", defaultOpenIdProviderMetadata.getRegistrationEndpoint());
        this.addStringSetterStatement(methodBuilder, "serviceDocumentation", defaultOpenIdProviderMetadata.getServiceDocumentation());
        this.addListStringSetterStatement(methodBuilder, "claimsLocalesSupported", "claimsLocalesSupported", defaultOpenIdProviderMetadata.getClaimsLocalesSupported());
        this.addListStringSetterStatement(methodBuilder, "uriLocalesSupported", "uriLocalesSupported", defaultOpenIdProviderMetadata.getUriLocalesSupported());
        this.addBooleanSetterStatement(methodBuilder, "claimsParameterSupported", defaultOpenIdProviderMetadata.getClaimsParameterSupported());
        this.addListStringSetterStatement(methodBuilder, "claimsSupported", "claimsSupported", defaultOpenIdProviderMetadata.getClaimsSupported());
        this.addListStringSetterStatement(methodBuilder, "codeChallengeMethodsSupported", "codeChallengeMethodsSupported", defaultOpenIdProviderMetadata.getCodeChallengeMethodsSupported());
        this.addStringSetterStatement(methodBuilder, "introspectionEndpoint", defaultOpenIdProviderMetadata.getIntrospectionEndpoint());
        this.addListStringSetterStatement(methodBuilder, "introspectionEndpointAuthMethodsSupported", "introspectionEndpointAuthMethodsSupported", defaultOpenIdProviderMetadata.getIntrospectionEndpointAuthMethodsSupported());
        this.addStringSetterStatement(methodBuilder, "revocationEndpoint", defaultOpenIdProviderMetadata.getRevocationEndpoint());
        this.addListStringSetterStatement(methodBuilder, "revocationEndpointAuthMethodsSupported", "revocationEndpointAuthMethodsSupported", defaultOpenIdProviderMetadata.getRevocationEndpointAuthMethodsSupported());
        this.addStringSetterStatement(methodBuilder, "checkSessionIframe", defaultOpenIdProviderMetadata.getCheckSessionIframe());
        this.addStringSetterStatement(methodBuilder, "endSessionEndpoint", defaultOpenIdProviderMetadata.getEndSessionEndpoint());
        this.addBooleanSetterStatement(methodBuilder, "requestUriParameterSupported", defaultOpenIdProviderMetadata.getRequestUriParameterSupported());
        this.addStringSetterStatement(methodBuilder, "opPolicyUri", defaultOpenIdProviderMetadata.getOpPolicyUri());
        this.addStringSetterStatement(methodBuilder, "opTosUri", defaultOpenIdProviderMetadata.getOpTosUri());
        this.addBooleanSetterStatement(methodBuilder, "requestParameterSupported", defaultOpenIdProviderMetadata.getRequestParameterSupported());
        this.addListStringSetterStatement(methodBuilder, "requestObjectEncryptionAlgValuesSupported", "requestObjectEncryptionAlgValuesSupported", defaultOpenIdProviderMetadata.getRequestObjectEncryptionAlgValuesSupported());
        this.addListStringSetterStatement(methodBuilder, "requestObjectEncryptionEncValuesSupported", "requestObjectEncryptionEncValuesSupported", defaultOpenIdProviderMetadata.getRequestObjectEncryptionEncValuesSupported());
        this.addListStringSetterStatement(methodBuilder, "requestObjectSigningAlgValuesSupported", "requestObjectSigningAlgValuesSupported", defaultOpenIdProviderMetadata.getRequestObjectSigningAlgValuesSupported());
        return methodBuilder.addStatement("return builder.build()", new Object[0]).build();
    }

    private void addStringSetterStatement(@NonNull MethodSpec.Builder methodBuilder, @NonNull String setter, @Nullable String value) {
        if (value != null) {
            methodBuilder.addStatement(BUILDER + setter + "($S)", new Object[]{value});
        }
    }

    private void addBooleanSetterStatement(@NonNull MethodSpec.Builder methodBuilder, @NonNull String setter, @Nullable Boolean value) {
        if (value != null) {
            methodBuilder.addStatement(BUILDER + setter + "($L)", new Object[]{value});
        }
    }

    private void addListStringSetterStatement(@NonNull MethodSpec.Builder methodBuilder, @NonNull String listVariableName, @NonNull String setter, @Nullable List<String> values) {
        if (values != null) {
            methodBuilder.addStatement("$T<$T> " + listVariableName + " = new $T<>()", new Object[]{List.class, String.class, ArrayList.class});
            for (String value : values) {
                methodBuilder.addStatement(listVariableName + ".add($S)", new Object[]{value});
            }
            methodBuilder.addStatement(BUILDER + setter + "(" + listVariableName + ")", new Object[0]);
        }
    }
}

