/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava3.instrument;

import io.micronaut.core.annotation.Internal;
import io.micronaut.rxjava3.instrument.RxInstrumentedCompletable;
import io.micronaut.rxjava3.instrument.RxInstrumentedCompletableObserver;
import io.micronaut.rxjava3.instrument.RxInstrumentedComponent;
import io.micronaut.rxjava3.instrument.RxInstrumentedConnectableFlowable;
import io.micronaut.rxjava3.instrument.RxInstrumentedConnectableObservable;
import io.micronaut.rxjava3.instrument.RxInstrumentedFlowable;
import io.micronaut.rxjava3.instrument.RxInstrumentedFlowableSubscriber;
import io.micronaut.rxjava3.instrument.RxInstrumentedMaybe;
import io.micronaut.rxjava3.instrument.RxInstrumentedMaybeObserver;
import io.micronaut.rxjava3.instrument.RxInstrumentedObservable;
import io.micronaut.rxjava3.instrument.RxInstrumentedObserver;
import io.micronaut.rxjava3.instrument.RxInstrumentedParallelFlowable;
import io.micronaut.rxjava3.instrument.RxInstrumentedSingle;
import io.micronaut.rxjava3.instrument.RxInstrumentedSingleObserver;
import io.micronaut.rxjava3.instrument.RxInstrumentedSubscriber;
import io.micronaut.rxjava3.instrument.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.flowables.ConnectableFlowable;
import io.reactivex.rxjava3.observables.ConnectableObservable;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import org.reactivestreams.Subscriber;

@Internal
final class RxInstrumentedWrappers {
    RxInstrumentedWrappers() {
    }

    static <T> Subscriber<T> wrap(Subscriber<T> downstream, RxInstrumenterFactory instrumenterFactory) {
        if (downstream instanceof RxInstrumentedComponent) {
            return downstream;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter != null) {
            if (downstream instanceof FlowableSubscriber) {
                return new RxInstrumentedFlowableSubscriber<T>(downstream, instrumenterFactory);
            }
            return new RxInstrumentedSubscriber<T>(downstream, instrumenterFactory);
        }
        return downstream;
    }

    static Completable wrap(Completable source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter == null) {
            return source;
        }
        return new RxInstrumentedCompletable((CompletableSource)source, instumenter);
    }

    static <T> Maybe<T> wrap(Maybe<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter == null) {
            return source;
        }
        return new RxInstrumentedMaybe<T>(source, instumenter);
    }

    static <T> Single<T> wrap(Single<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter == null) {
            return source;
        }
        return new RxInstrumentedSingle<T>(source, instumenter);
    }

    static <T> Observable<T> wrap(Observable<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter == null) {
            return source;
        }
        return new RxInstrumentedObservable<T>(source, instumenter);
    }

    static <T> ConnectableObservable<T> wrap(ConnectableObservable<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter == null) {
            return source;
        }
        return new RxInstrumentedConnectableObservable<T>(source, instumenter);
    }

    static <T> Flowable<T> wrap(Flowable<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter == null) {
            return source;
        }
        return new RxInstrumentedFlowable<T>(source, instumenter);
    }

    static <T> ConnectableFlowable<T> wrap(ConnectableFlowable<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter == null) {
            return source;
        }
        return new RxInstrumentedConnectableFlowable<T>(source, instumenter);
    }

    static <T> ParallelFlowable<T> wrap(ParallelFlowable<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        return new RxInstrumentedParallelFlowable<T>(source, instrumenterFactory);
    }

    static <T> Observer<T> wrap(Observer<T> downstream, RxInstrumenterFactory instrumenterFactory) {
        if (downstream instanceof RxInstrumentedComponent) {
            return downstream;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter != null) {
            return new RxInstrumentedObserver<T>(downstream, instrumenterFactory);
        }
        return downstream;
    }

    static <T> SingleObserver<T> wrap(SingleObserver<T> downstream, RxInstrumenterFactory instrumenterFactory) {
        if (downstream instanceof RxInstrumentedComponent) {
            return downstream;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter != null) {
            return new RxInstrumentedSingleObserver<T>(downstream, instrumenterFactory);
        }
        return downstream;
    }

    static <T> MaybeObserver<T> wrap(MaybeObserver<T> downstream, RxInstrumenterFactory instrumenterFactory) {
        if (downstream instanceof RxInstrumentedComponent) {
            return downstream;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter != null) {
            return new RxInstrumentedMaybeObserver<T>(downstream, instrumenterFactory);
        }
        return downstream;
    }

    static CompletableObserver wrap(CompletableObserver downstream, RxInstrumenterFactory instrumenterFactory) {
        if (downstream instanceof RxInstrumentedComponent) {
            return downstream;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter != null) {
            return new RxInstrumentedCompletableObserver(downstream, instrumenterFactory);
        }
        return downstream;
    }
}

