/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava3.instrument;

import io.micronaut.core.annotation.Internal;
import io.micronaut.rxjava3.instrument.RxInstrumentedComponent;
import io.micronaut.rxjava3.instrument.RxInstrumentedWrappers;
import io.micronaut.rxjava3.instrument.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import org.reactivestreams.Subscriber;

@Internal
final class RxInstrumentedParallelFlowable<T>
extends ParallelFlowable<T>
implements RxInstrumentedComponent {
    protected final ParallelFlowable<T> source;
    private final RxInstrumenterFactory instrumenterFactory;
    private final InvocationInstrumenter instrumenter;

    RxInstrumentedParallelFlowable(ParallelFlowable<T> source, RxInstrumenterFactory instrumenterFactory) {
        this.source = source;
        this.instrumenterFactory = instrumenterFactory;
        this.instrumenter = instrumenterFactory.create();
    }

    public int parallelism() {
        return this.source.parallelism();
    }

    public void subscribe(Subscriber<? super T>[] s) {
        if (!this.validate(s)) {
            return;
        }
        InvocationInstrumenter instrumenter = this.instrumenter;
        if (instrumenter == null) {
            this.source.subscribe(s);
            return;
        }
        int n = s.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Subscriber<? super T> z = s[i];
            parents[i] = RxInstrumentedWrappers.wrap(z, this.instrumenterFactory);
        }
        try (Instrumentation ignored = instrumenter.newInstrumentation();){
            this.source.subscribe(parents);
        }
    }
}

