/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava2.instrument;

import io.micronaut.core.annotation.Internal;
import io.micronaut.rxjava2.instrument.RxInstrumentedCompletable;
import io.micronaut.rxjava2.instrument.RxInstrumentedCompletableObserver;
import io.micronaut.rxjava2.instrument.RxInstrumentedComponent;
import io.micronaut.rxjava2.instrument.RxInstrumentedConnectableFlowable;
import io.micronaut.rxjava2.instrument.RxInstrumentedConnectableObservable;
import io.micronaut.rxjava2.instrument.RxInstrumentedFlowable;
import io.micronaut.rxjava2.instrument.RxInstrumentedFlowableSubscriber;
import io.micronaut.rxjava2.instrument.RxInstrumentedMaybe;
import io.micronaut.rxjava2.instrument.RxInstrumentedMaybeObserver;
import io.micronaut.rxjava2.instrument.RxInstrumentedObservable;
import io.micronaut.rxjava2.instrument.RxInstrumentedObserver;
import io.micronaut.rxjava2.instrument.RxInstrumentedParallelFlowable;
import io.micronaut.rxjava2.instrument.RxInstrumentedSingle;
import io.micronaut.rxjava2.instrument.RxInstrumentedSingleObserver;
import io.micronaut.rxjava2.instrument.RxInstrumentedSubscriber;
import io.micronaut.rxjava2.instrument.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.internal.fuseable.HasUpstreamCompletableSource;
import io.reactivex.internal.fuseable.HasUpstreamMaybeSource;
import io.reactivex.internal.fuseable.HasUpstreamObservableSource;
import io.reactivex.internal.fuseable.HasUpstreamPublisher;
import io.reactivex.internal.fuseable.HasUpstreamSingleSource;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.parallel.ParallelFlowable;
import org.reactivestreams.Subscriber;

@Internal
final class RxInstrumentedWrappers {
    RxInstrumentedWrappers() {
    }

    static <T> Subscriber<T> wrap(Subscriber<T> downstream, RxInstrumenterFactory instrumenterFactory) {
        if (RxInstrumentedWrappers.skipWrap(downstream)) {
            return downstream;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter != null) {
            if (downstream instanceof FlowableSubscriber) {
                return new RxInstrumentedFlowableSubscriber<T>(downstream, instrumenterFactory);
            }
            return new RxInstrumentedSubscriber<T>(downstream, instrumenterFactory);
        }
        return downstream;
    }

    static Completable wrap(Completable source, RxInstrumenterFactory instrumenterFactory) {
        if (RxInstrumentedWrappers.skipWrap(source)) {
            return source;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter == null) {
            return source;
        }
        return new RxInstrumentedCompletable((CompletableSource)source, instrumenter);
    }

    static <T> Maybe<T> wrap(Maybe<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (RxInstrumentedWrappers.skipWrap(source)) {
            return source;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter == null) {
            return source;
        }
        return new RxInstrumentedMaybe<T>(source, instrumenter);
    }

    static <T> Single<T> wrap(Single<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (RxInstrumentedWrappers.skipWrap(source)) {
            return source;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter == null) {
            return source;
        }
        return new RxInstrumentedSingle<T>(source, instrumenter);
    }

    static <T> Observable<T> wrap(Observable<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (RxInstrumentedWrappers.skipWrap(source)) {
            return source;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter == null) {
            return source;
        }
        return new RxInstrumentedObservable<T>(source, instrumenter);
    }

    static <T> ConnectableObservable<T> wrap(ConnectableObservable<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (RxInstrumentedWrappers.skipWrap(source)) {
            return source;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter == null) {
            return source;
        }
        return new RxInstrumentedConnectableObservable<T>(source, instrumenter);
    }

    static <T> Flowable<T> wrap(Flowable<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (RxInstrumentedWrappers.skipWrap(source)) {
            return source;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter == null) {
            return source;
        }
        return new RxInstrumentedFlowable<T>(source, instrumenter);
    }

    static <T> ConnectableFlowable<T> wrap(ConnectableFlowable<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (RxInstrumentedWrappers.skipWrap(source)) {
            return source;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter == null) {
            return source;
        }
        return new RxInstrumentedConnectableFlowable<T>(source, instrumenter);
    }

    static <T> ParallelFlowable<T> wrap(ParallelFlowable<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (RxInstrumentedWrappers.skipWrap(source)) {
            return source;
        }
        return new RxInstrumentedParallelFlowable<T>(source, instrumenterFactory);
    }

    static <T> Observer<T> wrap(Observer<T> downstream, RxInstrumenterFactory instrumenterFactory) {
        if (RxInstrumentedWrappers.skipWrap(downstream)) {
            return downstream;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter != null) {
            return new RxInstrumentedObserver<T>(downstream, instrumenterFactory);
        }
        return downstream;
    }

    static <T> SingleObserver<T> wrap(SingleObserver<T> downstream, RxInstrumenterFactory instrumenterFactory) {
        if (RxInstrumentedWrappers.skipWrap(downstream)) {
            return downstream;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter != null) {
            return new RxInstrumentedSingleObserver<T>(downstream, instrumenterFactory);
        }
        return downstream;
    }

    static <T> MaybeObserver<T> wrap(MaybeObserver<T> downstream, RxInstrumenterFactory instrumenterFactory) {
        if (RxInstrumentedWrappers.skipWrap(downstream)) {
            return downstream;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter != null) {
            return new RxInstrumentedMaybeObserver<T>(downstream, instrumenterFactory);
        }
        return downstream;
    }

    static CompletableObserver wrap(CompletableObserver downstream, RxInstrumenterFactory instrumenterFactory) {
        if (RxInstrumentedWrappers.skipWrap(downstream)) {
            return downstream;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter != null) {
            return new RxInstrumentedCompletableObserver(downstream, instrumenterFactory);
        }
        return downstream;
    }

    private static boolean skipWrap(Object source) {
        if (source instanceof RxInstrumentedComponent) {
            return true;
        }
        if (source instanceof HasUpstreamObservableSource) {
            return RxInstrumentedWrappers.skipWrap(((HasUpstreamObservableSource)source).source());
        }
        if (source instanceof HasUpstreamMaybeSource) {
            return RxInstrumentedWrappers.skipWrap(((HasUpstreamMaybeSource)source).source());
        }
        if (source instanceof HasUpstreamCompletableSource) {
            return RxInstrumentedWrappers.skipWrap(((HasUpstreamCompletableSource)source).source());
        }
        if (source instanceof HasUpstreamPublisher) {
            return RxInstrumentedWrappers.skipWrap(((HasUpstreamPublisher)source).source());
        }
        if (source instanceof HasUpstreamSingleSource) {
            return RxInstrumentedWrappers.skipWrap(((HasUpstreamSingleSource)source).source());
        }
        return false;
    }
}

