/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.functions;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.functions.FunctionsManagementAsyncClient;
import com.oracle.bmc.functions.requests.ChangeApplicationCompartmentRequest;
import com.oracle.bmc.functions.requests.CreateApplicationRequest;
import com.oracle.bmc.functions.requests.CreateFunctionRequest;
import com.oracle.bmc.functions.requests.DeleteApplicationRequest;
import com.oracle.bmc.functions.requests.DeleteFunctionRequest;
import com.oracle.bmc.functions.requests.GetApplicationRequest;
import com.oracle.bmc.functions.requests.GetFunctionRequest;
import com.oracle.bmc.functions.requests.ListApplicationsRequest;
import com.oracle.bmc.functions.requests.ListFunctionsRequest;
import com.oracle.bmc.functions.requests.UpdateApplicationRequest;
import com.oracle.bmc.functions.requests.UpdateFunctionRequest;
import com.oracle.bmc.functions.responses.ChangeApplicationCompartmentResponse;
import com.oracle.bmc.functions.responses.CreateApplicationResponse;
import com.oracle.bmc.functions.responses.CreateFunctionResponse;
import com.oracle.bmc.functions.responses.DeleteApplicationResponse;
import com.oracle.bmc.functions.responses.DeleteFunctionResponse;
import com.oracle.bmc.functions.responses.GetApplicationResponse;
import com.oracle.bmc.functions.responses.GetFunctionResponse;
import com.oracle.bmc.functions.responses.ListApplicationsResponse;
import com.oracle.bmc.functions.responses.ListFunctionsResponse;
import com.oracle.bmc.functions.responses.UpdateApplicationResponse;
import com.oracle.bmc.functions.responses.UpdateFunctionResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={FunctionsManagementAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class FunctionsManagementRxClient {
    FunctionsManagementAsyncClient client;

    FunctionsManagementRxClient(FunctionsManagementAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeApplicationCompartmentResponse> changeApplicationCompartment(ChangeApplicationCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeApplicationCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateApplicationResponse> createApplication(CreateApplicationRequest request) {
        return Single.create(emitter -> this.client.createApplication(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateFunctionResponse> createFunction(CreateFunctionRequest request) {
        return Single.create(emitter -> this.client.createFunction(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest request) {
        return Single.create(emitter -> this.client.deleteApplication(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteFunctionResponse> deleteFunction(DeleteFunctionRequest request) {
        return Single.create(emitter -> this.client.deleteFunction(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetApplicationResponse> getApplication(GetApplicationRequest request) {
        return Single.create(emitter -> this.client.getApplication(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetFunctionResponse> getFunction(GetFunctionRequest request) {
        return Single.create(emitter -> this.client.getFunction(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListApplicationsResponse> listApplications(ListApplicationsRequest request) {
        return Single.create(emitter -> this.client.listApplications(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListFunctionsResponse> listFunctions(ListFunctionsRequest request) {
        return Single.create(emitter -> this.client.listFunctions(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest request) {
        return Single.create(emitter -> this.client.updateApplication(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateFunctionResponse> updateFunction(UpdateFunctionRequest request) {
        return Single.create(emitter -> this.client.updateFunction(request, new AsyncHandlerEmitter(emitter)));
    }
}

