/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.containerengine;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.containerengine.ContainerEngineAsyncClient;
import com.oracle.bmc.containerengine.requests.CreateClusterRequest;
import com.oracle.bmc.containerengine.requests.CreateKubeconfigRequest;
import com.oracle.bmc.containerengine.requests.CreateNodePoolRequest;
import com.oracle.bmc.containerengine.requests.DeleteClusterRequest;
import com.oracle.bmc.containerengine.requests.DeleteNodePoolRequest;
import com.oracle.bmc.containerengine.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.containerengine.requests.GetClusterOptionsRequest;
import com.oracle.bmc.containerengine.requests.GetClusterRequest;
import com.oracle.bmc.containerengine.requests.GetNodePoolOptionsRequest;
import com.oracle.bmc.containerengine.requests.GetNodePoolRequest;
import com.oracle.bmc.containerengine.requests.GetWorkRequestRequest;
import com.oracle.bmc.containerengine.requests.ListClustersRequest;
import com.oracle.bmc.containerengine.requests.ListNodePoolsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestsRequest;
import com.oracle.bmc.containerengine.requests.UpdateClusterEndpointConfigRequest;
import com.oracle.bmc.containerengine.requests.UpdateClusterRequest;
import com.oracle.bmc.containerengine.requests.UpdateNodePoolRequest;
import com.oracle.bmc.containerengine.responses.CreateClusterResponse;
import com.oracle.bmc.containerengine.responses.CreateKubeconfigResponse;
import com.oracle.bmc.containerengine.responses.CreateNodePoolResponse;
import com.oracle.bmc.containerengine.responses.DeleteClusterResponse;
import com.oracle.bmc.containerengine.responses.DeleteNodePoolResponse;
import com.oracle.bmc.containerengine.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.containerengine.responses.GetClusterOptionsResponse;
import com.oracle.bmc.containerengine.responses.GetClusterResponse;
import com.oracle.bmc.containerengine.responses.GetNodePoolOptionsResponse;
import com.oracle.bmc.containerengine.responses.GetNodePoolResponse;
import com.oracle.bmc.containerengine.responses.GetWorkRequestResponse;
import com.oracle.bmc.containerengine.responses.ListClustersResponse;
import com.oracle.bmc.containerengine.responses.ListNodePoolsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestsResponse;
import com.oracle.bmc.containerengine.responses.UpdateClusterEndpointConfigResponse;
import com.oracle.bmc.containerengine.responses.UpdateClusterResponse;
import com.oracle.bmc.containerengine.responses.UpdateNodePoolResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={ContainerEngineAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ContainerEngineRxClient {
    ContainerEngineAsyncClient client;

    ContainerEngineRxClient(ContainerEngineAsyncClient client) {
        this.client = client;
    }

    public Single<CreateClusterResponse> createCluster(CreateClusterRequest request) {
        return Single.create(emitter -> this.client.createCluster(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateKubeconfigResponse> createKubeconfig(CreateKubeconfigRequest request) {
        return Single.create(emitter -> this.client.createKubeconfig(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateNodePoolResponse> createNodePool(CreateNodePoolRequest request) {
        return Single.create(emitter -> this.client.createNodePool(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteClusterResponse> deleteCluster(DeleteClusterRequest request) {
        return Single.create(emitter -> this.client.deleteCluster(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteNodePoolResponse> deleteNodePool(DeleteNodePoolRequest request) {
        return Single.create(emitter -> this.client.deleteNodePool(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteWorkRequestResponse> deleteWorkRequest(DeleteWorkRequestRequest request) {
        return Single.create(emitter -> this.client.deleteWorkRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetClusterResponse> getCluster(GetClusterRequest request) {
        return Single.create(emitter -> this.client.getCluster(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetClusterOptionsResponse> getClusterOptions(GetClusterOptionsRequest request) {
        return Single.create(emitter -> this.client.getClusterOptions(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetNodePoolResponse> getNodePool(GetNodePoolRequest request) {
        return Single.create(emitter -> this.client.getNodePool(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetNodePoolOptionsResponse> getNodePoolOptions(GetNodePoolOptionsRequest request) {
        return Single.create(emitter -> this.client.getNodePoolOptions(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListClustersResponse> listClusters(ListClustersRequest request) {
        return Single.create(emitter -> this.client.listClusters(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListNodePoolsResponse> listNodePools(ListNodePoolsRequest request) {
        return Single.create(emitter -> this.client.listNodePools(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateClusterResponse> updateCluster(UpdateClusterRequest request) {
        return Single.create(emitter -> this.client.updateCluster(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateClusterEndpointConfigResponse> updateClusterEndpointConfig(UpdateClusterEndpointConfigRequest request) {
        return Single.create(emitter -> this.client.updateClusterEndpointConfig(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateNodePoolResponse> updateNodePool(UpdateNodePoolRequest request) {
        return Single.create(emitter -> this.client.updateNodePool(request, new AsyncHandlerEmitter(emitter)));
    }
}

