/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.audit;

import com.oracle.bmc.audit.AuditAsyncClient;
import com.oracle.bmc.audit.requests.GetConfigurationRequest;
import com.oracle.bmc.audit.requests.ListEventsRequest;
import com.oracle.bmc.audit.requests.UpdateConfigurationRequest;
import com.oracle.bmc.audit.responses.GetConfigurationResponse;
import com.oracle.bmc.audit.responses.ListEventsResponse;
import com.oracle.bmc.audit.responses.UpdateConfigurationResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={AuditAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class AuditRxClient {
    AuditAsyncClient client;

    AuditRxClient(AuditAsyncClient client) {
        this.client = client;
    }

    public Single<GetConfigurationResponse> getConfiguration(GetConfigurationRequest request) {
        return Single.create(emitter -> this.client.getConfiguration(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListEventsResponse> listEvents(ListEventsRequest request) {
        return Single.create(emitter -> this.client.listEvents(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateConfigurationResponse> updateConfiguration(UpdateConfigurationRequest request) {
        return Single.create(emitter -> this.client.updateConfiguration(request, new AsyncHandlerEmitter(emitter)));
    }
}

