/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.dts;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.dts.TransferDeviceAsyncClient;
import com.oracle.bmc.dts.requests.CreateTransferDeviceRequest;
import com.oracle.bmc.dts.requests.DeleteTransferDeviceRequest;
import com.oracle.bmc.dts.requests.GetTransferDeviceRequest;
import com.oracle.bmc.dts.requests.ListTransferDevicesRequest;
import com.oracle.bmc.dts.requests.UpdateTransferDeviceRequest;
import com.oracle.bmc.dts.responses.CreateTransferDeviceResponse;
import com.oracle.bmc.dts.responses.DeleteTransferDeviceResponse;
import com.oracle.bmc.dts.responses.GetTransferDeviceResponse;
import com.oracle.bmc.dts.responses.ListTransferDevicesResponse;
import com.oracle.bmc.dts.responses.UpdateTransferDeviceResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={TransferDeviceAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class TransferDeviceRxClient {
    TransferDeviceAsyncClient client;

    TransferDeviceRxClient(TransferDeviceAsyncClient client) {
        this.client = client;
    }

    public Single<CreateTransferDeviceResponse> createTransferDevice(CreateTransferDeviceRequest request) {
        return Single.create(emitter -> this.client.createTransferDevice(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteTransferDeviceResponse> deleteTransferDevice(DeleteTransferDeviceRequest request) {
        return Single.create(emitter -> this.client.deleteTransferDevice(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetTransferDeviceResponse> getTransferDevice(GetTransferDeviceRequest request) {
        return Single.create(emitter -> this.client.getTransferDevice(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListTransferDevicesResponse> listTransferDevices(ListTransferDevicesRequest request) {
        return Single.create(emitter -> this.client.listTransferDevices(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateTransferDeviceResponse> updateTransferDevice(UpdateTransferDeviceRequest request) {
        return Single.create(emitter -> this.client.updateTransferDevice(request, new AsyncHandlerEmitter(emitter)));
    }
}

