/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.apigateway;

import com.oracle.bmc.apigateway.GatewayAsyncClient;
import com.oracle.bmc.apigateway.requests.ChangeGatewayCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateGatewayRequest;
import com.oracle.bmc.apigateway.requests.DeleteGatewayRequest;
import com.oracle.bmc.apigateway.requests.GetGatewayRequest;
import com.oracle.bmc.apigateway.requests.ListGatewaysRequest;
import com.oracle.bmc.apigateway.requests.UpdateGatewayRequest;
import com.oracle.bmc.apigateway.responses.ChangeGatewayCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateGatewayResponse;
import com.oracle.bmc.apigateway.responses.DeleteGatewayResponse;
import com.oracle.bmc.apigateway.responses.GetGatewayResponse;
import com.oracle.bmc.apigateway.responses.ListGatewaysResponse;
import com.oracle.bmc.apigateway.responses.UpdateGatewayResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={GatewayAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class GatewayRxClient {
    GatewayAsyncClient client;

    GatewayRxClient(GatewayAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeGatewayCompartmentResponse> changeGatewayCompartment(ChangeGatewayCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeGatewayCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateGatewayResponse> createGateway(CreateGatewayRequest request) {
        return Single.create(emitter -> this.client.createGateway(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteGatewayResponse> deleteGateway(DeleteGatewayRequest request) {
        return Single.create(emitter -> this.client.deleteGateway(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetGatewayResponse> getGateway(GetGatewayRequest request) {
        return Single.create(emitter -> this.client.getGateway(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListGatewaysResponse> listGateways(ListGatewaysRequest request) {
        return Single.create(emitter -> this.client.listGateways(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateGatewayResponse> updateGateway(UpdateGatewayRequest request) {
        return Single.create(emitter -> this.client.updateGateway(request, new AsyncHandlerEmitter(emitter)));
    }
}

