/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.mysql;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mysql.DbBackupsAsyncClient;
import com.oracle.bmc.mysql.requests.CreateBackupRequest;
import com.oracle.bmc.mysql.requests.DeleteBackupRequest;
import com.oracle.bmc.mysql.requests.GetBackupRequest;
import com.oracle.bmc.mysql.requests.ListBackupsRequest;
import com.oracle.bmc.mysql.requests.UpdateBackupRequest;
import com.oracle.bmc.mysql.responses.CreateBackupResponse;
import com.oracle.bmc.mysql.responses.DeleteBackupResponse;
import com.oracle.bmc.mysql.responses.GetBackupResponse;
import com.oracle.bmc.mysql.responses.ListBackupsResponse;
import com.oracle.bmc.mysql.responses.UpdateBackupResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={DbBackupsAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DbBackupsRxClient {
    DbBackupsAsyncClient client;

    DbBackupsRxClient(DbBackupsAsyncClient client) {
        this.client = client;
    }

    public Single<CreateBackupResponse> createBackup(CreateBackupRequest request) {
        return Single.create(emitter -> this.client.createBackup(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteBackupResponse> deleteBackup(DeleteBackupRequest request) {
        return Single.create(emitter -> this.client.deleteBackup(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetBackupResponse> getBackup(GetBackupRequest request) {
        return Single.create(emitter -> this.client.getBackup(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListBackupsResponse> listBackups(ListBackupsRequest request) {
        return Single.create(emitter -> this.client.listBackups(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateBackupResponse> updateBackup(UpdateBackupRequest request) {
        return Single.create(emitter -> this.client.updateBackup(request, new AsyncHandlerEmitter(emitter)));
    }
}

