/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.mysql;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mysql.MysqlaasAsyncClient;
import com.oracle.bmc.mysql.requests.CreateConfigurationRequest;
import com.oracle.bmc.mysql.requests.DeleteConfigurationRequest;
import com.oracle.bmc.mysql.requests.GetConfigurationRequest;
import com.oracle.bmc.mysql.requests.ListConfigurationsRequest;
import com.oracle.bmc.mysql.requests.ListShapesRequest;
import com.oracle.bmc.mysql.requests.ListVersionsRequest;
import com.oracle.bmc.mysql.requests.UpdateConfigurationRequest;
import com.oracle.bmc.mysql.responses.CreateConfigurationResponse;
import com.oracle.bmc.mysql.responses.DeleteConfigurationResponse;
import com.oracle.bmc.mysql.responses.GetConfigurationResponse;
import com.oracle.bmc.mysql.responses.ListConfigurationsResponse;
import com.oracle.bmc.mysql.responses.ListShapesResponse;
import com.oracle.bmc.mysql.responses.ListVersionsResponse;
import com.oracle.bmc.mysql.responses.UpdateConfigurationResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={MysqlaasAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class MysqlaasRxClient {
    MysqlaasAsyncClient client;

    MysqlaasRxClient(MysqlaasAsyncClient client) {
        this.client = client;
    }

    public Single<CreateConfigurationResponse> createConfiguration(CreateConfigurationRequest request) {
        return Single.create(emitter -> this.client.createConfiguration(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteConfigurationResponse> deleteConfiguration(DeleteConfigurationRequest request) {
        return Single.create(emitter -> this.client.deleteConfiguration(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetConfigurationResponse> getConfiguration(GetConfigurationRequest request) {
        return Single.create(emitter -> this.client.getConfiguration(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListConfigurationsResponse> listConfigurations(ListConfigurationsRequest request) {
        return Single.create(emitter -> this.client.listConfigurations(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListShapesResponse> listShapes(ListShapesRequest request) {
        return Single.create(emitter -> this.client.listShapes(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListVersionsResponse> listVersions(ListVersionsRequest request) {
        return Single.create(emitter -> this.client.listVersions(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateConfigurationResponse> updateConfiguration(UpdateConfigurationRequest request) {
        return Single.create(emitter -> this.client.updateConfiguration(request, new AsyncHandlerEmitter(emitter)));
    }
}

