/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.secrets;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.secrets.SecretsAsyncClient;
import com.oracle.bmc.secrets.requests.GetSecretBundleRequest;
import com.oracle.bmc.secrets.requests.ListSecretBundleVersionsRequest;
import com.oracle.bmc.secrets.responses.GetSecretBundleResponse;
import com.oracle.bmc.secrets.responses.ListSecretBundleVersionsResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={SecretsAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class SecretsRxClient {
    SecretsAsyncClient client;

    SecretsRxClient(SecretsAsyncClient client) {
        this.client = client;
    }

    public Single<GetSecretBundleResponse> getSecretBundle(GetSecretBundleRequest request) {
        return Single.create(emitter -> this.client.getSecretBundle(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSecretBundleVersionsResponse> listSecretBundleVersions(ListSecretBundleVersionsRequest request) {
        return Single.create(emitter -> this.client.listSecretBundleVersions(request, new AsyncHandlerEmitter(emitter)));
    }
}

