/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.limits;

import com.oracle.bmc.limits.LimitsAsyncClient;
import com.oracle.bmc.limits.requests.GetResourceAvailabilityRequest;
import com.oracle.bmc.limits.requests.ListLimitDefinitionsRequest;
import com.oracle.bmc.limits.requests.ListLimitValuesRequest;
import com.oracle.bmc.limits.requests.ListServicesRequest;
import com.oracle.bmc.limits.responses.GetResourceAvailabilityResponse;
import com.oracle.bmc.limits.responses.ListLimitDefinitionsResponse;
import com.oracle.bmc.limits.responses.ListLimitValuesResponse;
import com.oracle.bmc.limits.responses.ListServicesResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={LimitsAsyncClient.class, Single.class})
@Singleton
public class LimitsRxClient {
    LimitsAsyncClient client;

    LimitsRxClient(LimitsAsyncClient client) {
        this.client = client;
    }

    public Single<GetResourceAvailabilityResponse> getResourceAvailability(GetResourceAvailabilityRequest request) {
        return Single.create(emitter -> this.client.getResourceAvailability(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListLimitDefinitionsResponse> listLimitDefinitions(ListLimitDefinitionsRequest request) {
        return Single.create(emitter -> this.client.listLimitDefinitions(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListLimitValuesResponse> listLimitValues(ListLimitValuesRequest request) {
        return Single.create(emitter -> this.client.listLimitValues(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListServicesResponse> listServices(ListServicesRequest request) {
        return Single.create(emitter -> this.client.listServices(request, new AsyncHandlerEmitter(emitter)));
    }
}

