/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.bds;

import com.oracle.bmc.bds.BdsAsyncClient;
import com.oracle.bmc.bds.requests.AddAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.AddBlockStorageRequest;
import com.oracle.bmc.bds.requests.AddCloudSqlRequest;
import com.oracle.bmc.bds.requests.AddWorkerNodesRequest;
import com.oracle.bmc.bds.requests.ChangeBdsInstanceCompartmentRequest;
import com.oracle.bmc.bds.requests.ChangeShapeRequest;
import com.oracle.bmc.bds.requests.CreateBdsInstanceRequest;
import com.oracle.bmc.bds.requests.DeleteBdsInstanceRequest;
import com.oracle.bmc.bds.requests.GetAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.GetBdsInstanceRequest;
import com.oracle.bmc.bds.requests.GetWorkRequestRequest;
import com.oracle.bmc.bds.requests.ListAutoScalingConfigurationsRequest;
import com.oracle.bmc.bds.requests.ListBdsInstancesRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestsRequest;
import com.oracle.bmc.bds.requests.RemoveAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.RemoveCloudSqlRequest;
import com.oracle.bmc.bds.requests.RestartNodeRequest;
import com.oracle.bmc.bds.requests.UpdateAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.UpdateBdsInstanceRequest;
import com.oracle.bmc.bds.responses.AddAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.AddBlockStorageResponse;
import com.oracle.bmc.bds.responses.AddCloudSqlResponse;
import com.oracle.bmc.bds.responses.AddWorkerNodesResponse;
import com.oracle.bmc.bds.responses.ChangeBdsInstanceCompartmentResponse;
import com.oracle.bmc.bds.responses.ChangeShapeResponse;
import com.oracle.bmc.bds.responses.CreateBdsInstanceResponse;
import com.oracle.bmc.bds.responses.DeleteBdsInstanceResponse;
import com.oracle.bmc.bds.responses.GetAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.GetBdsInstanceResponse;
import com.oracle.bmc.bds.responses.GetWorkRequestResponse;
import com.oracle.bmc.bds.responses.ListAutoScalingConfigurationsResponse;
import com.oracle.bmc.bds.responses.ListBdsInstancesResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestsResponse;
import com.oracle.bmc.bds.responses.RemoveAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.RemoveCloudSqlResponse;
import com.oracle.bmc.bds.responses.RestartNodeResponse;
import com.oracle.bmc.bds.responses.UpdateAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.UpdateBdsInstanceResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={BdsAsyncClient.class, Single.class})
@Singleton
public class BdsRxClient {
    BdsAsyncClient client;

    BdsRxClient(BdsAsyncClient client) {
        this.client = client;
    }

    public Single<AddAutoScalingConfigurationResponse> addAutoScalingConfiguration(AddAutoScalingConfigurationRequest request) {
        return Single.create(emitter -> this.client.addAutoScalingConfiguration(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<AddBlockStorageResponse> addBlockStorage(AddBlockStorageRequest request) {
        return Single.create(emitter -> this.client.addBlockStorage(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<AddCloudSqlResponse> addCloudSql(AddCloudSqlRequest request) {
        return Single.create(emitter -> this.client.addCloudSql(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<AddWorkerNodesResponse> addWorkerNodes(AddWorkerNodesRequest request) {
        return Single.create(emitter -> this.client.addWorkerNodes(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeBdsInstanceCompartmentResponse> changeBdsInstanceCompartment(ChangeBdsInstanceCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeBdsInstanceCompartment(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeShapeResponse> changeShape(ChangeShapeRequest request) {
        return Single.create(emitter -> this.client.changeShape(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateBdsInstanceResponse> createBdsInstance(CreateBdsInstanceRequest request) {
        return Single.create(emitter -> this.client.createBdsInstance(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteBdsInstanceResponse> deleteBdsInstance(DeleteBdsInstanceRequest request) {
        return Single.create(emitter -> this.client.deleteBdsInstance(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAutoScalingConfigurationResponse> getAutoScalingConfiguration(GetAutoScalingConfigurationRequest request) {
        return Single.create(emitter -> this.client.getAutoScalingConfiguration(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetBdsInstanceResponse> getBdsInstance(GetBdsInstanceRequest request) {
        return Single.create(emitter -> this.client.getBdsInstance(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAutoScalingConfigurationsResponse> listAutoScalingConfigurations(ListAutoScalingConfigurationsRequest request) {
        return Single.create(emitter -> this.client.listAutoScalingConfigurations(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListBdsInstancesResponse> listBdsInstances(ListBdsInstancesRequest request) {
        return Single.create(emitter -> this.client.listBdsInstances(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<RemoveAutoScalingConfigurationResponse> removeAutoScalingConfiguration(RemoveAutoScalingConfigurationRequest request) {
        return Single.create(emitter -> this.client.removeAutoScalingConfiguration(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<RemoveCloudSqlResponse> removeCloudSql(RemoveCloudSqlRequest request) {
        return Single.create(emitter -> this.client.removeCloudSql(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<RestartNodeResponse> restartNode(RestartNodeRequest request) {
        return Single.create(emitter -> this.client.restartNode(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateAutoScalingConfigurationResponse> updateAutoScalingConfiguration(UpdateAutoScalingConfigurationRequest request) {
        return Single.create(emitter -> this.client.updateAutoScalingConfiguration(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateBdsInstanceResponse> updateBdsInstance(UpdateBdsInstanceRequest request) {
        return Single.create(emitter -> this.client.updateBdsInstance(request, new AsyncHandlerEmitter(emitter)));
    }
}

