/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.svm.core.annotate.AutomaticFeature;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.graal.AutomaticFeatureUtils;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.oraclecloud.clients.SdkAutomaticFeatureMetadata;
import io.micronaut.oraclecloud.clients.SdkClients;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
@Internal
final class SdkAutomaticFeature
implements Feature {
    SdkAutomaticFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Arrays.asList("org.glassfish.jersey.internal.LocalizationMessages", "org.glassfish.jersey.message.internal.MediaTypeProvider", "org.glassfish.jersey.message.internal.CacheControlProvider", "org.glassfish.jersey.message.internal.LinkProvider").forEach(n -> AutomaticFeatureUtils.initializeAtBuildTime((Feature.BeforeAnalysisAccess)access, (String)n));
        AnnotationMetadata annotationMetadata = this.getAnnotationMetadata(access);
        if (annotationMetadata != null) {
            HashSet reflectiveAccess = new HashSet();
            SdkAutomaticFeature.populateReflectionData(reflectiveAccess, ResponseHelper.ErrorCodeAndMessage.class);
            String[] classes = annotationMetadata.stringValues(SdkClients.class);
            for (String aClass : classes) {
                String packageName = NameUtils.getPackageName((String)aClass);
                String simpleName = NameUtils.getSimpleName((String)aClass);
                String string = packageName.replace("com.oracle.bmc", "io.micronaut.oraclecloud.clients") + "." + simpleName + "Factory";
                AutomaticFeatureUtils.initializeAtRunTime((Feature.BeforeAnalysisAccess)access, (String)string);
                Class c = access.findClassByName(aClass);
                if (c == null) continue;
                Set allInterfaces = ReflectionUtils.getAllInterfaces((Class)c);
                for (Class i : allInterfaces) {
                    if (i.getName().endsWith("Async")) continue;
                    SdkAutomaticFeature.populateReflectionData(reflectiveAccess, i);
                }
            }
            for (Class clazz : reflectiveAccess) {
                boolean hasNoArgsConstructor = !clazz.isEnum() && !clazz.isInterface() && this.hasNoArgsConstructor(clazz.getDeclaredConstructors());
                RuntimeReflection.register((Class[])new Class[]{clazz});
                if (hasNoArgsConstructor) {
                    RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{clazz});
                }
                for (Method method : clazz.getDeclaredMethods()) {
                    RuntimeReflection.register((Executable[])new Executable[]{method});
                }
                if (clazz.isInterface()) continue;
                for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                    RuntimeReflection.register((Field[])new Field[]{accessibleObject});
                }
            }
        }
    }

    private boolean hasNoArgsConstructor(Constructor<?>[] declaredConstructors) {
        boolean hasNoArgsConstructor = false;
        for (Constructor<?> declaredConstructor : declaredConstructors) {
            if (declaredConstructor.getParameterCount() != 0) continue;
            hasNoArgsConstructor = true;
            break;
        }
        return hasNoArgsConstructor;
    }

    static void populateReflectionData(Set<Class<?>> reflectiveAccess, Class<?> type) {
        Method[] methods;
        Class builder;
        JsonDeserialize deser = type.getAnnotation(JsonDeserialize.class);
        if (deser != null && (builder = deser.builder()) != Void.class && SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, builder)) {
            reflectiveAccess.add(builder);
            SdkAutomaticFeature.populateReflectionData(reflectiveAccess, builder);
        }
        for (Method m : methods = type.getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            Class<?> rt = m.getReturnType();
            if (Collection.class.isAssignableFrom(rt)) {
                Type arg;
                Type[] args;
                Type grt = m.getGenericReturnType();
                if (grt instanceof ParameterizedType && (args = ((ParameterizedType)grt).getActualTypeArguments()) != null && args.length == 1 && (arg = args[0]) instanceof Class && SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, arg)) {
                    Class t = (Class)arg;
                    reflectiveAccess.add(t);
                    SdkAutomaticFeature.populateReflectionData(reflectiveAccess, t);
                }
            } else if (SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, rt)) {
                reflectiveAccess.add(rt);
                SdkAutomaticFeature.populateReflectionData(reflectiveAccess, rt);
            }
            for (Class<?> pt : parameterTypes = m.getParameterTypes()) {
                if (!SdkAutomaticFeature.includeInReflectiveData(reflectiveAccess, pt)) continue;
                reflectiveAccess.add(pt);
                SdkAutomaticFeature.populateReflectionData(reflectiveAccess, pt);
            }
        }
    }

    static boolean includeInReflectiveData(Set<Class<?>> reflectiveAccess, Type rt) {
        return rt.getTypeName().startsWith("com.oracle.bmc") && !reflectiveAccess.contains(rt);
    }

    private AnnotationMetadata getAnnotationMetadata(Feature.BeforeAnalysisAccess access) {
        String targetClass = SdkAutomaticFeatureMetadata.class.getPackage().getName();
        return this.getAnnotationMetadata(access, targetClass);
    }

    private AnnotationMetadata getAnnotationMetadata(Feature.BeforeAnalysisAccess access, String targetClass) {
        return this.getBeanReference(access, targetClass).map(AnnotationMetadataProvider::getAnnotationMetadata).orElse(AnnotationMetadata.EMPTY_METADATA);
    }

    private Optional<BeanDefinitionReference<?>> getBeanReference(Feature.BeforeAnalysisAccess access, String targetClass) {
        Object o;
        String className = targetClass + ".$" + SdkAutomaticFeatureMetadata.class.getSimpleName() + "DefinitionClass";
        Class featureClass = access.findClassByName(className);
        if (featureClass != null && (o = InstantiationUtils.instantiate((Class)featureClass)) instanceof BeanDefinitionReference) {
            return Optional.ofNullable((BeanDefinitionReference)o);
        }
        return Optional.empty();
    }
}

