/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.dts;

import com.oracle.bmc.dts.TransferApplianceAsyncClient;
import com.oracle.bmc.dts.requests.CreateTransferApplianceAdminCredentialsRequest;
import com.oracle.bmc.dts.requests.CreateTransferApplianceRequest;
import com.oracle.bmc.dts.requests.DeleteTransferApplianceRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceCertificateAuthorityCertificateRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceEncryptionPassphraseRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceRequest;
import com.oracle.bmc.dts.requests.ListTransferAppliancesRequest;
import com.oracle.bmc.dts.requests.UpdateTransferApplianceRequest;
import com.oracle.bmc.dts.responses.CreateTransferApplianceAdminCredentialsResponse;
import com.oracle.bmc.dts.responses.CreateTransferApplianceResponse;
import com.oracle.bmc.dts.responses.DeleteTransferApplianceResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceCertificateAuthorityCertificateResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceEncryptionPassphraseResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceResponse;
import com.oracle.bmc.dts.responses.ListTransferAppliancesResponse;
import com.oracle.bmc.dts.responses.UpdateTransferApplianceResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={TransferApplianceAsyncClient.class, Single.class})
@Singleton
public class TransferApplianceRxClient {
    TransferApplianceAsyncClient client;

    TransferApplianceRxClient(TransferApplianceAsyncClient client) {
        this.client = client;
    }

    public Single<CreateTransferApplianceResponse> createTransferAppliance(CreateTransferApplianceRequest request) {
        return Single.create(emitter -> this.client.createTransferAppliance(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateTransferApplianceAdminCredentialsResponse> createTransferApplianceAdminCredentials(CreateTransferApplianceAdminCredentialsRequest request) {
        return Single.create(emitter -> this.client.createTransferApplianceAdminCredentials(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteTransferApplianceResponse> deleteTransferAppliance(DeleteTransferApplianceRequest request) {
        return Single.create(emitter -> this.client.deleteTransferAppliance(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetTransferApplianceResponse> getTransferAppliance(GetTransferApplianceRequest request) {
        return Single.create(emitter -> this.client.getTransferAppliance(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetTransferApplianceCertificateAuthorityCertificateResponse> getTransferApplianceCertificateAuthorityCertificate(GetTransferApplianceCertificateAuthorityCertificateRequest request) {
        return Single.create(emitter -> this.client.getTransferApplianceCertificateAuthorityCertificate(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetTransferApplianceEncryptionPassphraseResponse> getTransferApplianceEncryptionPassphrase(GetTransferApplianceEncryptionPassphraseRequest request) {
        return Single.create(emitter -> this.client.getTransferApplianceEncryptionPassphrase(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListTransferAppliancesResponse> listTransferAppliances(ListTransferAppliancesRequest request) {
        return Single.create(emitter -> this.client.listTransferAppliances(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateTransferApplianceResponse> updateTransferAppliance(UpdateTransferApplianceRequest request) {
        return Single.create(emitter -> this.client.updateTransferAppliance(request, new AsyncHandlerEmitter(emitter)));
    }
}

