/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.cims;

import com.oracle.bmc.cims.IncidentAsyncClient;
import com.oracle.bmc.cims.requests.CreateIncidentRequest;
import com.oracle.bmc.cims.requests.GetIncidentRequest;
import com.oracle.bmc.cims.requests.GetStatusRequest;
import com.oracle.bmc.cims.requests.ListIncidentResourceTypesRequest;
import com.oracle.bmc.cims.requests.ListIncidentsRequest;
import com.oracle.bmc.cims.requests.UpdateIncidentRequest;
import com.oracle.bmc.cims.requests.ValidateUserRequest;
import com.oracle.bmc.cims.responses.CreateIncidentResponse;
import com.oracle.bmc.cims.responses.GetIncidentResponse;
import com.oracle.bmc.cims.responses.GetStatusResponse;
import com.oracle.bmc.cims.responses.ListIncidentResourceTypesResponse;
import com.oracle.bmc.cims.responses.ListIncidentsResponse;
import com.oracle.bmc.cims.responses.UpdateIncidentResponse;
import com.oracle.bmc.cims.responses.ValidateUserResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={IncidentAsyncClient.class, Single.class})
@Singleton
public class IncidentRxClient {
    IncidentAsyncClient client;

    IncidentRxClient(IncidentAsyncClient client) {
        this.client = client;
    }

    public Single<CreateIncidentResponse> createIncident(CreateIncidentRequest request) {
        return Single.create(emitter -> this.client.createIncident(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetIncidentResponse> getIncident(GetIncidentRequest request) {
        return Single.create(emitter -> this.client.getIncident(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetStatusResponse> getStatus(GetStatusRequest request) {
        return Single.create(emitter -> this.client.getStatus(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListIncidentResourceTypesResponse> listIncidentResourceTypes(ListIncidentResourceTypesRequest request) {
        return Single.create(emitter -> this.client.listIncidentResourceTypes(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListIncidentsResponse> listIncidents(ListIncidentsRequest request) {
        return Single.create(emitter -> this.client.listIncidents(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateIncidentResponse> updateIncident(UpdateIncidentRequest request) {
        return Single.create(emitter -> this.client.updateIncident(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ValidateUserResponse> validateUser(ValidateUserRequest request) {
        return Single.create(emitter -> this.client.validateUser(request, new AsyncHandlerEmitter(emitter)));
    }
}

