/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.reflect.ClassUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.glassfish.jersey.internal.ServiceConfigurationError;

@TargetClass(className="org.glassfish.jersey.internal.ServiceFinder")
final class ServiceFinderReplacement<T>
implements Iterable<T> {
    @Alias
    private Class<T> serviceClass;
    @Alias
    private String serviceName;
    @Alias
    private ClassLoader classLoader;
    @Alias
    private boolean ignoreOnClassNotFound;

    @Substitute
    private ServiceFinderReplacement(Class<T> service, ClassLoader loader, boolean ignoreOnClassNotFound) {
        this(service, service.getName(), loader, ignoreOnClassNotFound);
    }

    @Substitute
    private ServiceFinderReplacement(Class<T> service, String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
        this.serviceClass = service;
        this.serviceName = serviceName;
        this.classLoader = loader;
        this.ignoreOnClassNotFound = ignoreOnClassNotFound;
    }

    @Override
    @Substitute
    public Iterator<T> iterator() {
        return ServiceLoader.load(this.serviceClass).iterator();
    }

    @Substitute
    public Class<T>[] toClassArray() throws ServiceConfigurationError {
        SoftServiceLoader loader = SoftServiceLoader.load(this.serviceClass, (ClassLoader)this.classLoader);
        ArrayList<Class> classes = new ArrayList<Class>();
        for (ServiceDefinition definition : loader) {
            Class aClass = ClassUtils.forName((String)definition.getName(), (ClassLoader)this.classLoader).orElse(null);
            classes.add(aClass);
        }
        return classes.toArray(new Class[0]);
    }
}

