/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.resourcesearch;

import com.oracle.bmc.resourcesearch.ResourceSearchAsyncClient;
import com.oracle.bmc.resourcesearch.requests.GetResourceTypeRequest;
import com.oracle.bmc.resourcesearch.requests.ListResourceTypesRequest;
import com.oracle.bmc.resourcesearch.requests.SearchResourcesRequest;
import com.oracle.bmc.resourcesearch.responses.GetResourceTypeResponse;
import com.oracle.bmc.resourcesearch.responses.ListResourceTypesResponse;
import com.oracle.bmc.resourcesearch.responses.SearchResourcesResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={ResourceSearchAsyncClient.class, Single.class})
@Singleton
public class ResourceSearchRxClient {
    ResourceSearchAsyncClient client;

    ResourceSearchRxClient(ResourceSearchAsyncClient client) {
        this.client = client;
    }

    public Single<GetResourceTypeResponse> getResourceType(GetResourceTypeRequest request) {
        return Single.create(emitter -> this.client.getResourceType(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListResourceTypesResponse> listResourceTypes(ListResourceTypesRequest request) {
        return Single.create(emitter -> this.client.listResourceTypes(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<SearchResourcesResponse> searchResources(SearchResourcesRequest request) {
        return Single.create(emitter -> this.client.searchResources(request, new AsyncHandlerEmitter(emitter)));
    }
}

