/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.mysql;

import com.oracle.bmc.mysql.DbSystemAsyncClient;
import com.oracle.bmc.mysql.requests.CreateDbSystemRequest;
import com.oracle.bmc.mysql.requests.DeleteDbSystemRequest;
import com.oracle.bmc.mysql.requests.GetDbSystemRequest;
import com.oracle.bmc.mysql.requests.ListDbSystemsRequest;
import com.oracle.bmc.mysql.requests.RestartDbSystemRequest;
import com.oracle.bmc.mysql.requests.StartDbSystemRequest;
import com.oracle.bmc.mysql.requests.StopDbSystemRequest;
import com.oracle.bmc.mysql.requests.UpdateDbSystemRequest;
import com.oracle.bmc.mysql.responses.CreateDbSystemResponse;
import com.oracle.bmc.mysql.responses.DeleteDbSystemResponse;
import com.oracle.bmc.mysql.responses.GetDbSystemResponse;
import com.oracle.bmc.mysql.responses.ListDbSystemsResponse;
import com.oracle.bmc.mysql.responses.RestartDbSystemResponse;
import com.oracle.bmc.mysql.responses.StartDbSystemResponse;
import com.oracle.bmc.mysql.responses.StopDbSystemResponse;
import com.oracle.bmc.mysql.responses.UpdateDbSystemResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={DbSystemAsyncClient.class, Single.class})
@Singleton
public class DbSystemRxClient {
    DbSystemAsyncClient client;

    DbSystemRxClient(DbSystemAsyncClient client) {
        this.client = client;
    }

    public Single<CreateDbSystemResponse> createDbSystem(CreateDbSystemRequest request) {
        return Single.create(emitter -> this.client.createDbSystem(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteDbSystemResponse> deleteDbSystem(DeleteDbSystemRequest request) {
        return Single.create(emitter -> this.client.deleteDbSystem(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetDbSystemResponse> getDbSystem(GetDbSystemRequest request) {
        return Single.create(emitter -> this.client.getDbSystem(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListDbSystemsResponse> listDbSystems(ListDbSystemsRequest request) {
        return Single.create(emitter -> this.client.listDbSystems(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<RestartDbSystemResponse> restartDbSystem(RestartDbSystemRequest request) {
        return Single.create(emitter -> this.client.restartDbSystem(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<StartDbSystemResponse> startDbSystem(StartDbSystemRequest request) {
        return Single.create(emitter -> this.client.startDbSystem(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<StopDbSystemResponse> stopDbSystem(StopDbSystemRequest request) {
        return Single.create(emitter -> this.client.stopDbSystem(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateDbSystemResponse> updateDbSystem(UpdateDbSystemRequest request) {
        return Single.create(emitter -> this.client.updateDbSystem(request, new AsyncHandlerEmitter(emitter)));
    }
}

