/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.limits;

import com.oracle.bmc.limits.QuotasAsyncClient;
import com.oracle.bmc.limits.requests.CreateQuotaRequest;
import com.oracle.bmc.limits.requests.DeleteQuotaRequest;
import com.oracle.bmc.limits.requests.GetQuotaRequest;
import com.oracle.bmc.limits.requests.ListQuotasRequest;
import com.oracle.bmc.limits.requests.UpdateQuotaRequest;
import com.oracle.bmc.limits.responses.CreateQuotaResponse;
import com.oracle.bmc.limits.responses.DeleteQuotaResponse;
import com.oracle.bmc.limits.responses.GetQuotaResponse;
import com.oracle.bmc.limits.responses.ListQuotasResponse;
import com.oracle.bmc.limits.responses.UpdateQuotaResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava.AsyncHandlerEmitter;
import io.reactivex.Single;
import javax.inject.Singleton;

@Requires(classes={QuotasAsyncClient.class, Single.class})
@Singleton
public class QuotasRxClient {
    QuotasAsyncClient client;

    QuotasRxClient(QuotasAsyncClient client) {
        this.client = client;
    }

    public Single<CreateQuotaResponse> createQuota(CreateQuotaRequest request) {
        return Single.create(emitter -> this.client.createQuota(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteQuotaResponse> deleteQuota(DeleteQuotaRequest request) {
        return Single.create(emitter -> this.client.deleteQuota(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetQuotaResponse> getQuota(GetQuotaRequest request) {
        return Single.create(emitter -> this.client.getQuota(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListQuotasResponse> listQuotas(ListQuotasRequest request) {
        return Single.create(emitter -> this.client.listQuotas(request, new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateQuotaResponse> updateQuota(UpdateQuotaRequest request) {
        return Single.create(emitter -> this.client.updateQuota(request, new AsyncHandlerEmitter(emitter)));
    }
}

